/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public class PleodendronTrunkPlacer
extends TrunkPlacer {
    public static final Codec<PleodendronTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PleodendronTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PleodendronTrunkPlacer::new));

    public PleodendronTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TropicraftTrunkPlacers.PLEODENDRON.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> acceptor, Random random, int height, BlockPos origin, TreeConfiguration config) {
        int i;
        PleodendronTrunkPlacer.m_161880_((LevelSimulatedReader)world, acceptor, (Random)random, (BlockPos)origin.m_7495_(), (TreeConfiguration)config);
        ArrayList<FoliagePlacer.FoliageAttachment> leafNodes = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (i = 0; i < height; ++i) {
            PleodendronTrunkPlacer.m_161893_((LevelSimulatedReader)world, acceptor, (Random)random, (BlockPos)origin.m_6630_(i), (TreeConfiguration)config);
        }
        leafNodes.add(new FoliagePlacer.FoliageAttachment(origin.m_6630_(height + 1), -1, false));
        for (i = 5; i < height - 4; ++i) {
            if (random.nextInt(4) != 0) continue;
            this.growBranches((LevelSimulatedRW)world, acceptor, random, origin.m_6630_(i), config, leafNodes);
        }
        return leafNodes;
    }

    private void growBranches(LevelSimulatedRW world, BiConsumer<BlockPos, BlockState> acceptor, Random random, BlockPos origin, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> leafNodes) {
        int count = random.nextInt(2) + 1;
        double thetaOffset = random.nextDouble() * 2.0 * Math.PI;
        for (int i = 0; i < count; ++i) {
            double theta = (double)i / (double)count * 2.0 * Math.PI + thetaOffset;
            theta += random.nextDouble() * Math.PI * 0.15;
            int dist = random.nextInt(3) == 0 ? 4 : 3;
            for (int j = 1; j <= dist; ++j) {
                int x = (int)(Math.cos(theta) * (double)j);
                int z = (int)(Math.sin(theta) * (double)j);
                BlockPos local = origin.m_142082_(x, 0, z);
                Direction.Axis axis = Util.getAxisBetween(origin, local);
                acceptor.accept(local, (BlockState)config.f_68185_.m_7112_(random, local).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis));
                if (j != dist) continue;
                leafNodes.add(new FoliagePlacer.FoliageAttachment(local.m_6630_(1), -2, false));
            }
        }
    }
}

