/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.BambooItemFrame;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.TropiBeeEntity;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import net.tropicraft.core.common.entity.egg.SeaUrchinEggEntity;
import net.tropicraft.core.common.entity.egg.StarfishEggEntity;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.entity.hostile.TropiSkellyEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.entity.neutral.EIHEntity;
import net.tropicraft.core.common.entity.neutral.IguanaEntity;
import net.tropicraft.core.common.entity.neutral.JaguarEntity;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.entity.passive.CowktailEntity;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FailgullEntity;
import net.tropicraft.core.common.entity.passive.FiddlerCrabEntity;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.entity.passive.HummingbirdEntity;
import net.tropicraft.core.common.entity.passive.TapirEntity;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;
import net.tropicraft.core.common.entity.passive.WhiteLippedPeccaryEntity;
import net.tropicraft.core.common.entity.passive.basilisk.BasiliskLizardEntity;
import net.tropicraft.core.common.entity.passive.monkey.SpiderMonkeyEntity;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import net.tropicraft.core.common.entity.projectile.ExplodingCoconutEntity;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.entity.projectile.SpearEntity;
import net.tropicraft.core.common.entity.underdasea.CuberaEntity;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;
import net.tropicraft.core.common.entity.underdasea.ManOWarEntity;
import net.tropicraft.core.common.entity.underdasea.MarlinEntity;
import net.tropicraft.core.common.entity.underdasea.PiranhaEntity;
import net.tropicraft.core.common.entity.underdasea.SardineEntity;
import net.tropicraft.core.common.entity.underdasea.SeaUrchinEntity;
import net.tropicraft.core.common.entity.underdasea.SeahorseEntity;
import net.tropicraft.core.common.entity.underdasea.SharkEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftDolphinEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftTropicalFishEntity;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TropicraftEntities {
    private static final float EGG_WIDTH = 0.4f;
    private static final float EGG_HEIGHT = 0.5f;
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"tropicraft");
    public static final RegistryObject<EntityType<EntityKoaHunter>> KOA_HUNTER = TropicraftEntities.register("koa", TropicraftEntities::koaHunter);
    public static final RegistryObject<EntityType<TropiCreeperEntity>> TROPI_CREEPER = TropicraftEntities.register("tropicreeper", TropicraftEntities::tropicreeper);
    public static final RegistryObject<EntityType<IguanaEntity>> IGUANA = TropicraftEntities.register("iguana", TropicraftEntities::iguana);
    public static final RegistryObject<EntityType<UmbrellaEntity>> UMBRELLA = TropicraftEntities.register("umbrella", TropicraftEntities::umbrella);
    public static final RegistryObject<EntityType<ChairEntity>> CHAIR = TropicraftEntities.register("chair", TropicraftEntities::chair);
    public static final RegistryObject<EntityType<BeachFloatEntity>> BEACH_FLOAT = TropicraftEntities.register("beach_float", TropicraftEntities::beachFloat);
    public static final RegistryObject<EntityType<TropiSkellyEntity>> TROPI_SKELLY = TropicraftEntities.register("tropiskelly", TropicraftEntities::tropiskelly);
    public static final RegistryObject<EntityType<EIHEntity>> EIH = TropicraftEntities.register("eih", TropicraftEntities::eih);
    public static final RegistryObject<EntityType<WallItemEntity>> WALL_ITEM = TropicraftEntities.register("wall_item", TropicraftEntities::wallItem);
    public static final RegistryObject<EntityType<BambooItemFrame>> BAMBOO_ITEM_FRAME = TropicraftEntities.register("bamboo_item_frame", TropicraftEntities::bambooItemFrame);
    public static final RegistryObject<EntityType<LavaBallEntity>> LAVA_BALL = null;
    public static final RegistryObject<EntityType<SeaTurtleEntity>> SEA_TURTLE = TropicraftEntities.register("turtle", TropicraftEntities::turtle);
    public static final RegistryObject<EntityType<MarlinEntity>> MARLIN = TropicraftEntities.register("marlin", TropicraftEntities::marlin);
    public static final RegistryObject<EntityType<FailgullEntity>> FAILGULL = TropicraftEntities.register("failgull", TropicraftEntities::failgull);
    public static final RegistryObject<EntityType<TropicraftDolphinEntity>> DOLPHIN = TropicraftEntities.register("dolphin", TropicraftEntities::dolphin);
    public static final RegistryObject<EntityType<SeahorseEntity>> SEAHORSE = TropicraftEntities.register("seahorse", TropicraftEntities::seahorse);
    public static final RegistryObject<EntityType<PoisonBlotEntity>> POISON_BLOT = TropicraftEntities.register("poison_blot", TropicraftEntities::poisonBlot);
    public static final RegistryObject<EntityType<TreeFrogEntity>> TREE_FROG = TropicraftEntities.register("tree_frog", TropicraftEntities::treeFrog);
    public static final RegistryObject<EntityType<SeaUrchinEntity>> SEA_URCHIN = TropicraftEntities.register("sea_urchin", TropicraftEntities::seaUrchin);
    public static final RegistryObject<EntityType<SeaUrchinEggEntity>> SEA_URCHIN_EGG_ENTITY = TropicraftEntities.register("sea_urchin_egg", TropicraftEntities::seaUrchinEgg);
    public static final RegistryObject<EntityType<StarfishEntity>> STARFISH = TropicraftEntities.register("starfish", TropicraftEntities::starfish);
    public static final RegistryObject<EntityType<StarfishEggEntity>> STARFISH_EGG = TropicraftEntities.register("starfish_egg", TropicraftEntities::starfishEgg);
    public static final RegistryObject<EntityType<VMonkeyEntity>> V_MONKEY = TropicraftEntities.register("v_monkey", TropicraftEntities::vervetMonkey);
    public static final RegistryObject<EntityType<SardineEntity>> RIVER_SARDINE = TropicraftEntities.register("sardine", TropicraftEntities::riverSardine);
    public static final RegistryObject<EntityType<PiranhaEntity>> PIRANHA = TropicraftEntities.register("piranha", TropicraftEntities::piranha);
    public static final RegistryObject<EntityType<TropicraftTropicalFishEntity>> TROPICAL_FISH = TropicraftEntities.register("tropical_fish", TropicraftEntities::tropicalFish);
    public static final RegistryObject<EntityType<EagleRayEntity>> EAGLE_RAY = TropicraftEntities.register("eagle_ray", TropicraftEntities::eagleRay);
    public static final RegistryObject<EntityType<TropiSpiderEntity>> TROPI_SPIDER = TropicraftEntities.register("tropi_spider", TropicraftEntities::tropiSpider);
    public static final RegistryObject<EntityType<TropiSpiderEggEntity>> TROPI_SPIDER_EGG = TropicraftEntities.register("tropi_spider_egg", TropicraftEntities::tropiSpiderEgg);
    public static final RegistryObject<EntityType<AshenMaskEntity>> ASHEN_MASK = TropicraftEntities.register("ashen_mask", TropicraftEntities::ashenMask);
    public static final RegistryObject<EntityType<AshenEntity>> ASHEN = TropicraftEntities.register("ashen", TropicraftEntities::ashen);
    public static final RegistryObject<EntityType<ExplodingCoconutEntity>> EXPLODING_COCONUT = TropicraftEntities.register("exploding_coconut", TropicraftEntities::explodingCoconut);
    public static final RegistryObject<EntityType<SharkEntity>> HAMMERHEAD = TropicraftEntities.register("hammerhead", TropicraftEntities::hammerhead);
    public static final RegistryObject<EntityType<SeaTurtleEggEntity>> SEA_TURTLE_EGG = TropicraftEntities.register("turtle_egg", TropicraftEntities::turtleEgg);
    public static final RegistryObject<EntityType<TropiBeeEntity>> TROPI_BEE = TropicraftEntities.register("tropibee", TropicraftEntities::tropiBee);
    public static final RegistryObject<EntityType<CowktailEntity>> COWKTAIL = TropicraftEntities.register("cowktail", TropicraftEntities::cowktail);
    public static final RegistryObject<EntityType<ManOWarEntity>> MAN_O_WAR = TropicraftEntities.register("man_o_war", TropicraftEntities::manOWar);
    public static final RegistryObject<EntityType<TapirEntity>> TAPIR = TropicraftEntities.register("tapir", TropicraftEntities::tapir);
    public static final RegistryObject<EntityType<JaguarEntity>> JAGUAR = TropicraftEntities.register("jaguar", TropicraftEntities::jaguar);
    public static final RegistryObject<EntityType<BasiliskLizardEntity>> BROWN_BASILISK_LIZARD = TropicraftEntities.register("brown_basilisk_lizard", TropicraftEntities::basiliskLizard);
    public static final RegistryObject<EntityType<BasiliskLizardEntity>> GREEN_BASILISK_LIZARD = TropicraftEntities.register("green_basilisk_lizard", TropicraftEntities::basiliskLizard);
    public static final RegistryObject<EntityType<HummingbirdEntity>> HUMMINGBIRD = TropicraftEntities.register("hummingbird", TropicraftEntities::hummingbird);
    public static final RegistryObject<EntityType<FiddlerCrabEntity>> FIDDLER_CRAB = TropicraftEntities.register("fiddler_crab", TropicraftEntities::fiddlerCrab);
    public static final RegistryObject<EntityType<SpiderMonkeyEntity>> SPIDER_MONKEY = TropicraftEntities.register("spider_monkey", TropicraftEntities::spiderMonkey);
    public static final RegistryObject<EntityType<WhiteLippedPeccaryEntity>> WHITE_LIPPED_PECCARY = TropicraftEntities.register("white_lipped_peccary", TropicraftEntities::whiteLippedPeccary);
    public static final RegistryObject<EntityType<CuberaEntity>> CUBERA = TropicraftEntities.register("cubera", TropicraftEntities::cubera);
    public static final RegistryObject<EntityType<FishingBobberEntity>> FISHING_BOBBER = TropicraftEntities.register("fishing_bobber", TropicraftEntities::fishingBobber);
    public static final RegistryObject<EntityType<SpearEntity>> SPEAR = TropicraftEntities.register("spear", TropicraftEntities::spear);

    private static <E extends Entity, T extends EntityType<E>> RegistryObject<EntityType<E>> register(String name, Supplier<EntityType.Builder<E>> sup) {
        return ENTITIES.register(name, () -> ((EntityType.Builder)sup.get()).m_20712_(name));
    }

    private static EntityType.Builder<CowktailEntity> cowktail() {
        return EntityType.Builder.m_20704_(CowktailEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 1.4f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<ManOWarEntity> manOWar() {
        return EntityType.Builder.m_20704_(ManOWarEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.6f, 0.8f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiBeeEntity> tropiBee() {
        return EntityType.Builder.m_20704_(TropiBeeEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaTurtleEggEntity> turtleEgg() {
        return EntityType.Builder.m_20704_(SeaTurtleEggEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<SharkEntity> hammerhead() {
        return EntityType.Builder.m_20704_(SharkEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(2.4f, 1.4f).setTrackingRange(5).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<ExplodingCoconutEntity> explodingCoconut() {
        return EntityType.Builder.m_20704_(ExplodingCoconutEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<AshenMaskEntity> ashenMask() {
        return EntityType.Builder.m_20704_(AshenMaskEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.2f).setTrackingRange(6).setUpdateInterval(100).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<AshenEntity> ashen() {
        return EntityType.Builder.m_20704_(AshenEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 1.3f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSpiderEntity> tropiSpider() {
        return EntityType.Builder.m_20704_(TropiSpiderEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.4f, 0.9f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSpiderEggEntity> tropiSpiderEgg() {
        return EntityType.Builder.m_20704_(TropiSpiderEggEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<EagleRayEntity> eagleRay() {
        return EntityType.Builder.m_20704_(EagleRayEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(2.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropicraftTropicalFishEntity> tropicalFish() {
        return EntityType.Builder.m_20704_(TropicraftTropicalFishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SardineEntity> riverSardine() {
        return EntityType.Builder.m_20704_(SardineEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<PiranhaEntity> piranha() {
        return EntityType.Builder.m_20704_(PiranhaEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<VMonkeyEntity> vervetMonkey() {
        return EntityType.Builder.m_20704_(VMonkeyEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<StarfishEggEntity> starfishEgg() {
        return EntityType.Builder.m_20704_(StarfishEggEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<StarfishEntity> starfish() {
        return EntityType.Builder.m_20704_(StarfishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(15).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaUrchinEggEntity> seaUrchinEgg() {
        return EntityType.Builder.m_20704_(SeaUrchinEggEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(15).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<SeaUrchinEntity> seaUrchin() {
        return EntityType.Builder.m_20704_(SeaUrchinEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TreeFrogEntity> treeFrog() {
        return EntityType.Builder.m_20704_(TreeFrogEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<PoisonBlotEntity> poisonBlot() {
        return EntityType.Builder.m_20704_(PoisonBlotEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeahorseEntity> seahorse() {
        return EntityType.Builder.m_20704_(SeahorseEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropicraftDolphinEntity> dolphin() {
        return EntityType.Builder.m_20704_(TropicraftDolphinEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(1.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<FailgullEntity> failgull() {
        return EntityType.Builder.m_20704_(FailgullEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<MarlinEntity> marlin() {
        return EntityType.Builder.m_20704_(MarlinEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(1.4f, 0.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaTurtleEntity> turtle() {
        return EntityType.Builder.m_20704_(SeaTurtleEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.8f, 0.35f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<BambooItemFrame> bambooItemFrame() {
        return EntityType.Builder.m_20704_(BambooItemFrame::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LavaBallEntity> lavaBall() {
        return EntityType.Builder.m_20704_(LavaBallEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<WallItemEntity> wallItem() {
        return EntityType.Builder.m_20704_(WallItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<EIHEntity> eih() {
        return EntityType.Builder.m_20704_(EIHEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.2f, 3.25f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSkellyEntity> tropiskelly() {
        return EntityType.Builder.m_20704_(TropiSkellyEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 1.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<UmbrellaEntity> umbrella() {
        return EntityType.Builder.m_20704_(UmbrellaEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 4.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<ChairEntity> chair() {
        return EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 0.5f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<BeachFloatEntity> beachFloat() {
        return EntityType.Builder.m_20704_(BeachFloatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 0.175f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<IguanaEntity> iguana() {
        return EntityType.Builder.m_20704_(IguanaEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).m_20719_().setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<EntityKoaHunter> koaHunter() {
        return EntityType.Builder.m_20704_(EntityKoaHunter::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f).setTrackingRange(8).setUpdateInterval(3).m_20719_().setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiCreeperEntity> tropicreeper() {
        return EntityType.Builder.m_20704_(TropiCreeperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TapirEntity> tapir() {
        return EntityType.Builder.m_20704_(TapirEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<JaguarEntity> jaguar() {
        return EntityType.Builder.m_20704_(JaguarEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<BasiliskLizardEntity> basiliskLizard() {
        return EntityType.Builder.m_20704_(BasiliskLizardEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<HummingbirdEntity> hummingbird() {
        return EntityType.Builder.m_20704_(HummingbirdEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<FiddlerCrabEntity> fiddlerCrab() {
        return EntityType.Builder.m_20704_(FiddlerCrabEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.2f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SpiderMonkeyEntity> spiderMonkey() {
        return EntityType.Builder.m_20704_(SpiderMonkeyEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.6f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<WhiteLippedPeccaryEntity> whiteLippedPeccary() {
        return EntityType.Builder.m_20704_(WhiteLippedPeccaryEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<CuberaEntity> cubera() {
        return EntityType.Builder.m_20704_(CuberaEntity::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(1.2f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<FishingBobberEntity> fishingBobber() {
        return EntityType.Builder.m_20704_(FishingBobberEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.2f, 0.8f).setTrackingRange(128).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SpearEntity> spear() {
        return EntityType.Builder.m_20704_(SpearEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).setTrackingRange(4).m_20717_(20).setShouldReceiveVelocityUpdates(true);
    }

    public static void registerSpawns() {
        TropicraftEntities.registerWaterSpawn((EntityType)TROPICAL_FISH.get(), WaterAnimal::m_186237_);
        TropicraftEntities.registerWaterSpawn((EntityType)RIVER_SARDINE.get(), WaterAnimal::m_186237_);
        TropicraftEntities.registerWaterSpawn((EntityType)PIRANHA.get(), WaterAnimal::m_186237_);
        TropicraftEntities.registerWaterSpawn((EntityType)DOLPHIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)EAGLE_RAY.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)MARLIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)SEAHORSE.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)SEA_URCHIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)STARFISH.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)HAMMERHEAD.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)MAN_O_WAR.get(), TropicraftEntities::canSpawnSurfaceOceanWaterMob);
        TropicraftEntities.registerLandSpawn((EntityType)KOA_HUNTER.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_CREEPER.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)IGUANA.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_SKELLY.get(), Monster::m_33017_);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_SPIDER.get(), Monster::m_33017_);
        TropicraftEntities.registerLandSpawn((EntityType)EIH.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)SEA_TURTLE.get(), SeaTurtleEntity::canSpawnOnLand);
        TropicraftEntities.registerLandSpawn((EntityType)TREE_FROG.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)V_MONKEY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)COWKTAIL.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TAPIR.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)JAGUAR.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)BROWN_BASILISK_LIZARD.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)GREEN_BASILISK_LIZARD.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)HUMMINGBIRD.get(), HummingbirdEntity::canHummingbirdSpawnOn);
        TropicraftEntities.registerNoRestrictionSpawn((EntityType)FIDDLER_CRAB.get(), FiddlerCrabEntity::canCrabSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)SPIDER_MONKEY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)WHITE_LIPPED_PECCARY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerWaterSpawn((EntityType)CUBERA.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerLandSpawn((EntityType)ASHEN.get(), Mob::m_21400_);
        TropicraftEntities.registerLandSpawn((EntityType)FAILGULL.get(), Mob::m_21400_);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_BEE.get(), Mob::m_21400_);
    }

    public static boolean canAnimalSpawn(EntityType<? extends Mob> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random random) {
        BlockState groundState = worldIn.m_8055_(pos.m_7495_());
        return groundState.m_60734_() == Blocks.f_50440_ || groundState.m_60767_() == Material.f_76317_ || groundState.m_204336_(TropicraftTags.Blocks.MUD);
    }

    private static <T extends Mob> void registerLandSpawn(EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    private static <T extends Mob> void registerWaterSpawn(EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    private static <T extends Mob> void registerNoRestrictionSpawn(EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        SpawnPlacements.m_21754_(type, (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    public static <T extends Mob> boolean canSpawnOceanWaterMob(EntityType<T> waterMob, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((LevelReader)world);
        return pos.m_123342_() > 90 && pos.m_123342_() < seaLevel && world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static <T extends Mob> boolean canSpawnSurfaceOceanWaterMob(EntityType<T> waterMob, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((LevelReader)world);
        return pos.m_123342_() > seaLevel - 3 && pos.m_123342_() < seaLevel && world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    @SubscribeEvent
    public static void onCreateEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KOA_HUNTER.get(), EntityKoaBase.createAttributes().m_22265_());
        event.put((EntityType)TROPI_CREEPER.get(), TropiCreeperEntity.createAttributes().m_22265_());
        event.put((EntityType)IGUANA.get(), IguanaEntity.createAttributes().m_22265_());
        event.put((EntityType)TROPI_SKELLY.get(), TropiSkellyEntity.createAttributes().m_22265_());
        event.put((EntityType)EIH.get(), EIHEntity.createAttributes().m_22265_());
        event.put((EntityType)SEA_TURTLE.get(), SeaTurtleEntity.m_30207_().m_22265_());
        event.put((EntityType)MARLIN.get(), MarlinEntity.createAttributes().m_22265_());
        event.put((EntityType)FAILGULL.get(), FailgullEntity.createAttributes().m_22265_());
        event.put((EntityType)DOLPHIN.get(), TropicraftDolphinEntity.m_28379_().m_22265_());
        event.put((EntityType)SEAHORSE.get(), SeahorseEntity.createAttributes().m_22265_());
        event.put((EntityType)TREE_FROG.get(), TreeFrogEntity.createAttributes().m_22265_());
        event.put((EntityType)SEA_URCHIN.get(), SeaUrchinEntity.createAttributes().m_22265_());
        event.put((EntityType)SEA_URCHIN_EGG_ENTITY.get(), EggEntity.createAttributes().m_22265_());
        event.put((EntityType)STARFISH.get(), StarfishEntity.createAttributes().m_22265_());
        event.put((EntityType)STARFISH_EGG.get(), EggEntity.createAttributes().m_22265_());
        event.put((EntityType)V_MONKEY.get(), VMonkeyEntity.createAttributes().m_22265_());
        event.put((EntityType)RIVER_SARDINE.get(), SardineEntity.createAttributes().m_22265_());
        event.put((EntityType)PIRANHA.get(), PiranhaEntity.createAttributes().m_22265_());
        event.put((EntityType)TROPICAL_FISH.get(), TropicraftTropicalFishEntity.createAttributes().m_22265_());
        event.put((EntityType)EAGLE_RAY.get(), EagleRayEntity.createAttributes().m_22265_());
        event.put((EntityType)TROPI_SPIDER.get(), TropiSpiderEntity.m_33815_().m_22265_());
        event.put((EntityType)TROPI_SPIDER_EGG.get(), EggEntity.createAttributes().m_22265_());
        event.put((EntityType)ASHEN.get(), AshenEntity.createAttributes().m_22265_());
        event.put((EntityType)HAMMERHEAD.get(), SharkEntity.createAttributes().m_22265_());
        event.put((EntityType)SEA_TURTLE_EGG.get(), EggEntity.createAttributes().m_22265_());
        event.put((EntityType)TROPI_BEE.get(), TropiBeeEntity.m_27858_().m_22265_());
        event.put((EntityType)COWKTAIL.get(), CowktailEntity.m_28307_().m_22265_());
        event.put((EntityType)MAN_O_WAR.get(), ManOWarEntity.createAttributes().m_22265_());
        event.put((EntityType)TAPIR.get(), TapirEntity.createAttributes().m_22265_());
        event.put((EntityType)JAGUAR.get(), JaguarEntity.createAttributes().m_22265_());
        event.put((EntityType)BROWN_BASILISK_LIZARD.get(), BasiliskLizardEntity.createAttributes().m_22265_());
        event.put((EntityType)GREEN_BASILISK_LIZARD.get(), BasiliskLizardEntity.createAttributes().m_22265_());
        event.put((EntityType)HUMMINGBIRD.get(), HummingbirdEntity.createAttributes().m_22265_());
        event.put((EntityType)FIDDLER_CRAB.get(), FiddlerCrabEntity.createAttributes().m_22265_());
        event.put((EntityType)SPIDER_MONKEY.get(), SpiderMonkeyEntity.createAttributes().m_22265_());
        event.put((EntityType)WHITE_LIPPED_PECCARY.get(), WhiteLippedPeccaryEntity.createAttributes().m_22265_());
        event.put((EntityType)CUBERA.get(), CuberaEntity.createAttributes().m_22265_());
    }
}

