/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIKoaMate
extends Goal {
    private final EntityKoaBase villagerObj;
    private EntityKoaBase mate;
    private final Level world;
    private int matingTimeout;
    private final long TIME_BETWEEN_POPULATION_CHECKS = 200L;
    private final int MAX_TOWN_POPULATION = 10;
    private long lastTimeCheckedVillagePopulation = -1L;
    private int cachedVillagePopulation = 0;

    public EntityAIKoaMate(EntityKoaBase villagerIn) {
        this.villagerObj = villagerIn;
        this.world = villagerIn.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.villagerObj.m_146764_() != 0) {
            return false;
        }
        if (this.villagerObj.m_21187_().nextInt(500) != 0) {
            return false;
        }
        if (this.canTownHandleMoreVillagers() && this.villagerObj.getIsWillingToMate(true)) {
            List listEntities = this.world.m_45976_(EntityKoaBase.class, this.villagerObj.m_142469_().m_82377_(8.0, 3.0, 8.0));
            EntityKoaBase clEnt = null;
            double clDist = 9999.0;
            for (EntityKoaBase ent : listEntities) {
                if (ent == this.villagerObj || !ent.getIsWillingToMate(true) || ent.m_6162_() || this.villagerObj.m_6162_() || !((double)this.villagerObj.m_20270_((Entity)ent) < clDist)) continue;
                clEnt = ent;
                clDist = this.villagerObj.m_20270_((Entity)ent);
            }
            if (clEnt != null) {
                this.mate = clEnt;
                return true;
            }
        }
        return false;
    }

    public void m_8056_() {
        this.matingTimeout = 300;
        this.villagerObj.setMating(true);
        if (this.mate != null) {
            this.mate.setMating(true);
        }
    }

    public void m_8041_() {
        this.mate = null;
        this.villagerObj.setMating(false);
    }

    public boolean m_8045_() {
        boolean result;
        boolean bl = result = this.matingTimeout >= 0 && this.canTownHandleMoreVillagers() && this.villagerObj.m_146764_() == 0 && this.villagerObj.getIsWillingToMate(false);
        if (!result) {
            // empty if block
        }
        return result;
    }

    public void m_8037_() {
        --this.matingTimeout;
        this.villagerObj.m_21563_().m_24960_((Entity)this.mate, 10.0f, 30.0f);
        if (this.villagerObj.m_20280_((Entity)this.mate) > 2.25) {
            this.villagerObj.m_21573_().m_5624_((Entity)this.mate, 0.75);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.mate.setMating(false);
            this.giveBirth();
        }
        if (this.villagerObj.m_21187_().nextInt(35) == 0) {
            this.world.m_7605_((Entity)this.villagerObj, (byte)12);
        }
    }

    private boolean canTownHandleMoreVillagers() {
        double range = 100.0;
        if (this.lastTimeCheckedVillagePopulation + 200L < this.world.m_46467_()) {
            this.lastTimeCheckedVillagePopulation = this.world.m_46467_();
            List listEntities = this.world.m_45976_(EntityKoaBase.class, this.villagerObj.m_142469_().m_82377_(range, range, range));
            this.cachedVillagePopulation = listEntities.size();
            return listEntities.size() < 10;
        }
        return this.cachedVillagePopulation < 10;
    }

    private void giveBirth() {
        Villager entityvillager = this.villagerObj.m_142606_((ServerLevel)this.world, (AgeableMob)this.mate);
        this.mate.m_146762_(6000);
        this.villagerObj.m_146762_(6000);
        this.mate.setIsWillingToMate(false);
        this.villagerObj.setIsWillingToMate(false);
        entityvillager.m_146762_(-24000);
        entityvillager.m_7678_(this.villagerObj.m_20185_(), this.villagerObj.m_20186_(), this.villagerObj.m_20189_(), 0.0f, 0.0f);
        if (entityvillager instanceof EntityKoaBase) {
            ((EntityKoaBase)entityvillager).setVillageAndDimID(this.villagerObj.getVillageID(), this.villagerObj.getVillageDimension());
            entityvillager.m_21446_(this.villagerObj.m_21534_(), EntityKoaBase.MAX_HOME_DISTANCE);
            ((EntityKoaBase)entityvillager).updateUniqueEntityAI();
            entityvillager.f_19853_.m_5594_(null, entityvillager.m_142538_(), SoundEvents.f_11752_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.world.m_7967_((Entity)entityvillager);
        this.world.m_7605_((Entity)entityvillager, (byte)12);
    }
}

