/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import com.google.common.collect.ImmutableList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EggEntity
extends LivingEntity {
    private static final EntityDataAccessor<Integer> HATCH_DELAY = SynchedEntityData.m_135353_(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public double rotationRand = 0.0;

    public EggEntity(EntityType<? extends EggEntity> type, Level w) {
        super(type, w);
        this.f_19811_ = true;
        this.m_146922_(this.f_19796_.nextInt(360));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 2.0);
    }

    public void m_7378_(CompoundTag compound) {
        this.f_19797_ = compound.m_128451_("ticks");
        this.setHatchDelay(compound.m_128451_("hatchDelay"));
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("ticks", this.f_19797_);
        compound.m_128405_("hatchDelay", this.getHatchDelay());
        super.m_7380_(compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HATCH_DELAY, (Object)0);
        this.setHatchDelay(-60 + this.f_19796_.nextInt(120));
    }

    public abstract boolean shouldEggRenderFlat();

    public abstract String getEggTexture();

    public abstract Entity onHatch();

    public abstract int getHatchTime();

    public abstract int getPreHatchMovement();

    public int getRandomHatchDelay() {
        return (Integer)this.m_20088_().m_135370_(HATCH_DELAY);
    }

    public boolean isHatching() {
        return this.f_19797_ > this.getHatchTime() + this.getRandomHatchDelay();
    }

    public boolean isNearHatching() {
        return this.f_19797_ > this.getHatchTime() + this.getRandomHatchDelay() - this.getPreHatchMovement();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isNearHatching()) {
            this.rotationRand += (double)(0.1707f * this.f_19853_.f_46441_.nextFloat());
            if (this.f_19797_ >= this.getHatchTime() && !this.f_19853_.f_46443_) {
                Entity ent = this.onHatch();
                ent.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.f_19853_.m_7967_(ent);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void setHatchDelay(int i) {
        this.m_20088_().m_135381_(HATCH_DELAY, (Object)(-60 + this.f_19796_.nextInt(120)));
    }

    public int getHatchDelay() {
        return (Integer)this.m_20088_().m_135370_(HATCH_DELAY);
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }
}

