/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiSpiderEntity
extends Spider {
    private static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.m_135353_(TropiSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int SPIDER_MATURE_AGE = 12000;
    private static final int SPIDER_MAX_EGGS = 10;
    private static final long SPIDER_MIN_EGG_DELAY = 12000L;
    private static final int SPIDER_EGG_CHANCE = 1000;
    private BlockPos nestSite;
    private TropiSpiderEntity mother = null;
    private long ticksSinceLastEgg = 0L;
    public byte initialType = 0;

    public TropiSpiderEntity(EntityType<? extends Spider> type, Level world) {
        super(type, world);
        this.f_19797_ = 12000;
        this.ticksSinceLastEgg = this.f_19797_;
    }

    public static TropiSpiderEntity haveBaby(TropiSpiderEntity mother) {
        TropiSpiderEntity baby = new TropiSpiderEntity((EntityType<? extends Spider>)((EntityType)TropicraftEntities.TROPI_SPIDER.get()), mother.f_19853_);
        baby.setSpiderType(Type.CHILD);
        baby.f_19797_ = 0;
        baby.mother = mother;
        return baby;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)this.initialType);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false));
        this.f_21345_.m_25352_(7, (Goal)new EntityAIWanderNotLazy((PathfinderMob)this, 0.8, 40));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.m_7639_() != null && damageSrc.m_7639_() instanceof LivingEntity) {
            this.m_6710_((LivingEntity)damageSrc.m_7639_());
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    public boolean m_6147_() {
        return this.m_33816_() && this.m_21573_().m_26571_();
    }

    public boolean m_33816_() {
        return this.f_19862_;
    }

    public void m_8119_() {
        this.f_19789_ = 0.0f;
        super.m_8119_();
        LivingEntity attackTarget = this.m_5448_();
        if (attackTarget != null && this.m_20280_((Entity)attackTarget) < 128.0) {
            Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)attackTarget, 0.8f);
        }
        if (!this.f_19853_.f_46443_ && attackTarget != null && this.f_19861_ && this.f_19796_.nextInt(3) == 0 && attackTarget.m_20270_((Entity)this) < 5.0f) {
            this.m_21573_().m_26573_();
            this.m_6135_();
            this.f_20887_ = 0.3f;
        } else {
            this.f_20887_ = 0.2f;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.getSpiderType() == Type.CHILD) {
                if (this.f_19797_ >= 12000) {
                    this.setSpiderType(Type.ADULT);
                }
                if (this.mother != null) {
                    if (this.m_20280_((Entity)this.mother) > 16.0) {
                        Util.tryMoveToEntityLivingLongDist((Mob)this, (Entity)this.mother, 0.8f);
                    } else {
                        this.m_21573_().m_26573_();
                    }
                    if (this.mother.m_5448_() != null) {
                        this.m_6710_(this.mother.m_5448_());
                    }
                }
            }
            if (this.getSpiderType() == Type.ADULT) {
                if (this.mother != null) {
                    if (!this.mother.m_6084_()) {
                        this.mother = null;
                        this.m_21573_().m_26573_();
                        this.m_6710_(null);
                    }
                    this.m_6710_((LivingEntity)this.mother);
                }
                if (this.f_19796_.nextInt(1000) == 0 && this.ticksSinceLastEgg > 12000L && this.f_19797_ % 80 == 0) {
                    this.buildNest();
                }
            }
            if (this.getSpiderType() == Type.MOTHER && this.nestSite != null) {
                if (this.ticksSinceLastEgg < 2000L) {
                    if (!this.m_142538_().m_123314_((Vec3i)this.nestSite, 16.0)) {
                        Util.tryMoveToXYZLongDist((Mob)this, this.nestSite, 0.9f);
                    }
                } else {
                    this.nestSite = null;
                }
            }
            ++this.ticksSinceLastEgg;
        }
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.nextInt(20) == 0 ? super.m_7515_() : null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
        if (this.getSpiderType() == Type.CHILD) {
            if (this.f_19796_.nextInt(20) == 0) {
                super.m_7355_(pos, blockState);
            }
        } else {
            super.m_7355_(pos, blockState);
        }
    }

    public boolean m_6094_() {
        return this.getSpiderType() != Type.MOTHER;
    }

    public void buildNest() {
        if (!this.f_19853_.f_46443_) {
            this.setSpiderType(Type.MOTHER);
            int r = this.f_19796_.nextInt(10) + 1;
            if (r < 2) {
                return;
            }
            for (int i = 0; i < r; ++i) {
                TropiSpiderEggEntity egg = (TropiSpiderEggEntity)((EntityType)TropicraftEntities.TROPI_SPIDER_EGG.get()).m_20615_(this.f_19853_);
                egg.setMotherId(this.m_142081_());
                egg.m_6034_((float)this.m_142538_().m_123341_() + this.f_19796_.nextFloat(), this.m_142538_().m_123342_(), (float)this.m_142538_().m_123343_() + this.f_19796_.nextFloat());
                this.f_19853_.m_7967_((Entity)egg);
                this.ticksSinceLastEgg = 0L;
            }
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    BlockPos pos;
                    if (this.f_19796_.nextInt(8) != 0 || !this.f_19853_.m_8055_(pos = new BlockPos(this.m_142538_().m_123341_() - 2 + x, this.m_142538_().m_123342_(), this.m_142538_().m_123343_() - 2 + z)).m_60734_().equals(Blocks.f_50016_) || !this.f_19853_.m_8055_(pos.m_7495_()).m_60767_().m_76333_()) continue;
                    this.f_19853_.m_46597_(pos, Blocks.f_50033_.m_49966_());
                }
            }
            this.nestSite = this.m_142538_();
        }
    }

    public void m_7380_(CompoundTag n) {
        n.m_128405_("ticks", this.f_19797_);
        n.m_128344_("spiderType", (byte)this.getSpiderType().ordinal());
        n.m_128356_("timeSinceLastEgg", this.ticksSinceLastEgg);
        super.m_7380_(n);
    }

    public void m_7378_(CompoundTag n) {
        this.f_19797_ = n.m_128451_("ticks");
        this.setSpiderType(n.m_128445_("spiderType"));
        this.ticksSinceLastEgg = n.m_128454_("timeSinceLastEgg");
        super.m_7378_(n);
    }

    public Type getSpiderType() {
        return Type.VALUES[(Byte)this.m_20088_().m_135370_(TYPE)];
    }

    public void setSpiderType(Type type) {
        this.m_20088_().m_135381_(TYPE, (Object)((byte)type.ordinal()));
        this.m_6210_();
    }

    public void setSpiderType(byte b) {
        this.m_20088_().m_135381_(TYPE, (Object)b);
        this.m_6210_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.TROPI_SPIDER_SPAWN_EGG.get());
    }

    public static enum Type {
        ADULT,
        MOTHER,
        CHILD;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

