/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.item.TropicraftItems;

public final class FiddlerCrabEntity
extends Animal {
    public FiddlerCrabEntity(EntityType<? extends FiddlerCrabEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.f_21342_ = new CrabMoveController((Mob)this);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.15f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickLimbSwing();
    }

    private void tickLimbSwing() {
        this.f_20923_ = this.f_20924_;
        double deltaX = this.m_20185_() - this.f_19854_;
        double deltaZ = this.m_20189_() - this.f_19856_;
        float deltaYaw = Mth.m_14177_((float)(this.f_20883_ - this.f_20884_));
        float move = Mth.m_14116_((float)((float)(deltaX * deltaX + deltaZ * deltaZ)));
        float rotate = Math.abs(deltaYaw);
        float targetAmount = move * 4.0f + rotate * 0.25f;
        targetAmount = Math.min(targetAmount, 0.25f);
        this.f_20924_ += (targetAmount - this.f_20924_) * 0.4f;
        this.f_20925_ += this.f_20924_;
    }

    public void m_21043_(LivingEntity entity, boolean flying) {
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public FiddlerCrabEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.FIDDLER_CRAB_SPAWN_EGG.get());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_6129_() {
        return !this.f_19861_;
    }

    public int m_8085_() {
        return 30;
    }

    public static boolean canCrabSpawn(EntityType<? extends FiddlerCrabEntity> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundBlock = world.m_8055_(groundPos);
        if (groundBlock.m_60767_() != Material.f_76317_) {
            return false;
        }
        if (!groundBlock.isValidSpawn((LevelReader)world, groundPos, SpawnPlacements.Type.NO_RESTRICTIONS, type)) {
            return false;
        }
        BlockState block = world.m_8055_(pos);
        FluidState fluid = world.m_6425_(pos);
        return !block.m_60838_((BlockGetter)world, pos) && !block.m_60803_() && !block.m_204336_(BlockTags.f_13054_) && (fluid.m_76178_() || fluid.m_205070_(FluidTags.f_13131_));
    }

    static final class CrabMoveController
    extends MoveControl {
        private static final double RAD_TO_DEG = 57.29577951308232;

        CrabMoveController(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.tickMoveTo();
            } else if (this.f_24981_ == MoveControl.Operation.WAIT) {
                this.f_24974_.m_21564_(0.0f);
                this.f_24974_.m_21570_(0.0f);
            }
        }

        private void tickMoveTo() {
            double dx = this.f_24975_ - this.f_24974_.m_20185_();
            double dz = this.f_24977_ - this.f_24974_.m_20189_();
            double dy = this.f_24976_ - this.f_24974_.m_20186_();
            double distance2 = dx * dx + dy * dy + dz * dz;
            if (distance2 < 2.5E-7) {
                this.f_24974_.m_21564_(0.0f);
                this.f_24974_.m_21570_(0.0f);
                return;
            }
            float forward = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float leftTarget = forward - 90.0f;
            float rightTarget = forward + 90.0f;
            float yaw = this.f_24974_.m_146908_();
            float targetYaw = CrabMoveController.closerAngle(yaw, leftTarget, rightTarget);
            float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
            float strafe = targetYaw < forward ? -1.0f : 1.0f;
            this.f_24974_.m_146922_(this.m_24991_(yaw, targetYaw, 10.0f));
            this.f_24974_.m_7910_(speed);
            this.f_24974_.m_21564_(0.0f);
            this.f_24974_.m_21570_(strafe * speed);
        }

        private static float closerAngle(float reference, float left, float right) {
            float deltaRight;
            float deltaLeft = Math.abs(Mth.m_14177_((float)(reference - left)));
            if (deltaLeft < (deltaRight = Math.abs(Mth.m_14177_((float)(reference - right))))) {
                return left;
            }
            return right;
        }
    }
}

