/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.ai.TropiCreeperSwellGoal;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiCreeperEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(TropiCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(TropiCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int prevTimeSinceIgnited;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public TropiCreeperEntity(EntityType<? extends PathfinderMob> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TropiCreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float distance, float pMultiplier, DamageSource pSource) {
        boolean fall = super.m_142535_(distance, pMultiplier, pSource);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return fall;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Fuse", (short)this.fuseTime);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compound.m_128379_("ignited", this.hasIgnited());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Fuse", 99)) {
            this.fuseTime = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128445_("ExplosionRadius");
        }
        if (compound.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.prevTimeSinceIgnited = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.m_8119_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public int getCreeperState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setCreeperState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            player.m_6674_(hand);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            this.f_20890_ = true;
            int radius = 5;
            int radiusSq = radius * radius;
            BlockPos center = this.m_142538_();
            HolderSet.Named smallFlowers = Registry.f_122824_.m_203561_(TropicraftTags.Blocks.SMALL_FLOWERS);
            for (int i = 0; i < 3 * radiusSq; ++i) {
                BlockPos attempt = center.m_142082_(this.f_19796_.nextInt(radius * 2 + 1) - radius, 0, this.f_19796_.nextInt(radius * 2 + 1) - radius);
                if (!(attempt.m_123331_((Vec3i)center) < (double)radiusSq)) continue;
                attempt = attempt.m_6630_(radius);
                while (this.f_19853_.m_8055_(attempt).m_60767_().m_76336_() && attempt.m_123342_() > center.m_123342_() - radius) {
                    attempt = attempt.m_7495_();
                }
                attempt = attempt.m_7494_();
                BlockState state = smallFlowers.m_203450_(this.f_19796_).map(Holder::m_203334_).orElse(Blocks.f_50016_).m_49966_();
                if (!state.m_60710_((LevelReader)this.f_19853_, attempt)) continue;
                this.f_19853_.m_46597_(attempt, state);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.spawnLingeringCloud();
        } else {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1.0, 0.0, 0.0);
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }

    public float getCreeperFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevTimeSinceIgnited, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.TROPICREEPER_SPAWN_EGG.get());
    }
}

