/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class ManOWarEntity
extends WaterAnimal {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;
    private int attackTimer = 0;

    public ManOWarEntity(EntityType<? extends ManOWarEntity> type, Level world) {
        super(type, world);
        this.f_19796_.setSeed(this.m_142049_());
        this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
        this.f_21364_ = 7;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MoveRandomGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FleeGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6040_() {
        return true;
    }

    public LivingEntity m_5448_() {
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.lastTentacleAngle = this.tentacleAngle;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.f_19796_.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_20072_()) {
            if (this.f_19796_.nextInt(5) == 0 && this.attackTimer <= 0) {
                List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82377_(2.0, 4.0, 2.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_);
                for (LivingEntity ent : list) {
                    if (ent.m_6095_() == TropicraftEntities.MAN_O_WAR.get() || !ent.m_20069_()) continue;
                    ent.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
                    this.attackTimer = 20;
                }
            }
            if (this.squidRotation < (float)Math.PI) {
                float lvt_1_1_ = this.squidRotation / (float)Math.PI;
                this.tentacleAngle = Mth.m_14031_((float)(lvt_1_1_ * lvt_1_1_ * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_20334_(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            Vec3 motion = this.m_20184_();
            double horizontalDistance = motion.m_165924_();
            this.f_20883_ += (-((float)Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)Mth.m_14136_((double)horizontalDistance, (double)motion.f_82480_)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            this.tentacleAngle = Mth.m_14154_((float)Mth.m_14031_((float)this.squidRotation)) * (float)Math.PI * 0.25f;
            if (!this.f_19853_.f_46443_) {
                double lvt_1_3_ = this.m_20184_().f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    lvt_1_3_ = 0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1);
                } else if (!this.m_20068_()) {
                    lvt_1_3_ -= 0.08;
                }
                this.m_20334_(0.0, lvt_1_3_ * (double)0.98f, 0.0);
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    public void m_6667_(DamageSource d) {
        super.m_6667_(d);
        if (!this.f_19853_.f_46443_) {
            int numDrops = 3 + this.f_19796_.nextInt(1);
            for (int i = 0; i < numDrops; ++i) {
                this.m_20000_((ItemLike)Items.f_42518_, 1);
            }
        }
    }

    public int m_8100_() {
        return 120;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    public void m_7023_(Vec3 vector) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.m_7822_(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.MAN_O_WAR_SPAWN_EGG.get());
    }

    static class MoveRandomGoal
    extends Goal {
        private final ManOWarEntity manOWarEntity;

        public MoveRandomGoal(ManOWarEntity p_i48823_2_) {
            this.manOWarEntity = p_i48823_2_;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int lvt_1_1_ = this.manOWarEntity.m_21216_();
            if (lvt_1_1_ > 100) {
                this.manOWarEntity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.manOWarEntity.m_21187_().nextInt(50) == 0 || !this.manOWarEntity.m_20069_() || !this.manOWarEntity.hasMovementVector()) {
                float lvt_2_1_ = this.manOWarEntity.m_21187_().nextFloat() * ((float)Math.PI * 2);
                float lvt_3_1_ = Mth.m_14089_((float)lvt_2_1_) * 0.2f;
                float lvt_4_1_ = -0.1f + this.manOWarEntity.m_21187_().nextFloat() * 0.2f;
                float lvt_5_1_ = Mth.m_14031_((float)lvt_2_1_) * 0.2f;
                this.manOWarEntity.setMovementVector(lvt_3_1_, lvt_4_1_, lvt_5_1_);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean m_8036_() {
            LivingEntity lvt_1_1_ = ManOWarEntity.this.m_142581_();
            if (ManOWarEntity.this.m_20069_() && lvt_1_1_ != null) {
                return ManOWarEntity.this.m_20280_((Entity)lvt_1_1_) < 100.0;
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = 0;
        }

        public void m_8037_() {
            ++this.tickCounter;
            LivingEntity target = ManOWarEntity.this.m_142581_();
            if (target != null) {
                Vec3 lvt_2_1_ = new Vec3(ManOWarEntity.this.m_20185_() - target.m_20185_(), ManOWarEntity.this.m_20186_() - target.m_20186_(), ManOWarEntity.this.m_20189_() - target.m_20189_());
                BlockState block = ManOWarEntity.this.f_19853_.m_8055_(new BlockPos(ManOWarEntity.this.m_20185_() + lvt_2_1_.f_82479_, ManOWarEntity.this.m_20186_() + lvt_2_1_.f_82480_, ManOWarEntity.this.m_20189_() + lvt_2_1_.f_82481_));
                FluidState fluid = ManOWarEntity.this.f_19853_.m_6425_(new BlockPos(ManOWarEntity.this.m_20185_() + lvt_2_1_.f_82479_, ManOWarEntity.this.m_20186_() + lvt_2_1_.f_82480_, ManOWarEntity.this.m_20189_() + lvt_2_1_.f_82481_));
                if (fluid.m_205070_(FluidTags.f_13131_) || block.m_60795_()) {
                    double lvt_5_1_ = lvt_2_1_.m_82553_();
                    if (lvt_5_1_ > 0.0) {
                        lvt_2_1_.m_82541_();
                        float lvt_7_1_ = 3.0f;
                        if (lvt_5_1_ > 5.0) {
                            lvt_7_1_ = (float)((double)lvt_7_1_ - (lvt_5_1_ - 5.0) / 5.0);
                        }
                        if (lvt_7_1_ > 0.0f) {
                            lvt_2_1_ = lvt_2_1_.m_82490_((double)lvt_7_1_);
                        }
                    }
                    if (block.m_60795_()) {
                        lvt_2_1_ = lvt_2_1_.m_82492_(0.0, lvt_2_1_.f_82480_, 0.0);
                    }
                    ManOWarEntity.this.setMovementVector((float)lvt_2_1_.f_82479_ / 20.0f, (float)lvt_2_1_.f_82480_ / 20.0f, (float)lvt_2_1_.f_82481_ / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    ManOWarEntity.this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, ManOWarEntity.this.m_20185_(), ManOWarEntity.this.m_20186_(), ManOWarEntity.this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

