/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;

public class ArmorMaterials {
    private static final Ingredient NO_INGREDIENT = new Ingredient(Stream.empty()){

        public boolean test(@Nullable ItemStack stack) {
            return false;
        }
    };
    public static final ArmorMaterial ASHEN_MASK = new AshenMask();
    public static final ArmorMaterial NIGEL_STACHE = new NigelStache();
    public static final ArmorMaterial SCALE_ARMOR = ArmorMaterials.createArmorMaterial(18, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11672_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TropicraftItems.SCALE.get()}), "scale", 0.5f, 0.0f);
    public static final ArmorMaterial FIRE_ARMOR = ArmorMaterials.createArmorMaterial(12, new int[]{2, 4, 5, 2}, 9, SoundEvents.f_11677_, NO_INGREDIENT, "fire", 0.1f, 0.0f);
    public static final ArmorMaterial SCUBA = ArmorMaterials.createArmorMaterial(10, new int[]{0, 0, 0, 0}, 0, SoundEvents.f_11675_, NO_INGREDIENT, "scuba_goggles", 0.0f, 0.0f);

    public static ArmorMaterial createArmorMaterial(final int durability, final int[] dmgReduction, final int enchantability, final SoundEvent soundEvent, final Ingredient repairMaterial, final String name, final float toughness, final float knockbackResistance) {
        return new ArmorMaterial(){

            public int m_7366_(EquipmentSlot equipmentSlotType) {
                return durability;
            }

            public int m_7365_(EquipmentSlot equipmentSlotType) {
                return dmgReduction[equipmentSlotType.m_20749_()];
            }

            public int m_6646_() {
                return enchantability;
            }

            public SoundEvent m_7344_() {
                return soundEvent;
            }

            public Ingredient m_6230_() {
                return repairMaterial;
            }

            public String m_6082_() {
                return name;
            }

            public float m_6651_() {
                return toughness;
            }

            public float m_6649_() {
                return knockbackResistance;
            }
        };
    }

    private static class AshenMask
    implements ArmorMaterial {
        private AshenMask() {
        }

        public int m_7366_(EquipmentSlot slotIn) {
            return 10;
        }

        public int m_7365_(EquipmentSlot slotIn) {
            return slotIn == EquipmentSlot.HEAD ? 1 : 0;
        }

        public int m_6646_() {
            return 15;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_204132_(TropicraftTags.Items.ASHEN_MASKS);
        }

        public String m_6082_() {
            return "mask";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }

    private static class NigelStache
    implements ArmorMaterial {
        private NigelStache() {
        }

        public int m_7366_(EquipmentSlot slotIn) {
            return 10;
        }

        public int m_7365_(EquipmentSlot slotIn) {
            return slotIn == EquipmentSlot.HEAD ? 1 : 0;
        }

        public int m_6646_() {
            return 15;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TropicraftItems.NIGEL_STACHE.get()});
        }

        public String m_6082_() {
            return "nigel";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

