/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.FireArmorItem;
import net.tropicraft.core.common.item.FurnitureItem;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.ScaleArmorItem;
import net.tropicraft.core.common.item.ShellItem;
import net.tropicraft.core.common.item.TropicalMusicDiscItem;
import net.tropicraft.core.common.item.TropicraftFishBucketItem;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.TropicraftSpawnEgg;
import net.tropicraft.core.common.item.scuba.ScubaFlippersItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaHarnessItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class Builder {
    public static Supplier<Item> item() {
        return Builder.item(Builder.getDefaultProperties());
    }

    public static Supplier<Item> item(Item.Properties properties) {
        return Builder.item(Item::new, properties);
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor) {
        return Builder.item(ctor, Builder.getDefaultProperties());
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor, Item.Properties properties) {
        return Builder.item(ctor, () -> properties);
    }

    public static <T> Supplier<T> item(Function<Item.Properties, T> ctor, Supplier<Item.Properties> properties) {
        return () -> ctor.apply((Item.Properties)properties.get());
    }

    public static Supplier<ItemNameBlockItem> blockNamedItem(Supplier<? extends Block> block) {
        return Builder.item((Item.Properties p) -> new ItemNameBlockItem((Block)block.get(), p));
    }

    private static <T extends FurnitureEntity> Supplier<FurnitureItem<T>> furniture(Supplier<EntityType<T>> type, DyeColor color) {
        return Builder.item((Item.Properties p) -> new FurnitureItem((Item.Properties)p, type, color));
    }

    public static Supplier<FurnitureItem<UmbrellaEntity>> umbrella(DyeColor color) {
        return Builder.furniture(TropicraftEntities.UMBRELLA, color);
    }

    public static Supplier<FurnitureItem<ChairEntity>> chair(DyeColor color) {
        return Builder.furniture(TropicraftEntities.CHAIR, color);
    }

    public static Supplier<FurnitureItem<BeachFloatEntity>> beachFloat(DyeColor color) {
        return Builder.furniture(TropicraftEntities.BEACH_FLOAT, color);
    }

    public static <T extends AbstractFish> Supplier<Item> fishBucket(Supplier<EntityType<T>> type) {
        return Builder.item((Item.Properties p) -> new TropicraftFishBucketItem(type, (Fluid)Fluids.f_76193_, Builder.getDefaultProperties().m_41487_(1)));
    }

    public static Supplier<Item> shell() {
        return Builder.item(ShellItem::new);
    }

    public static Supplier<Item> food(FoodProperties food) {
        return Builder.item(Builder.getDefaultProperties().m_41489_(food));
    }

    public static Supplier<CocktailItem> cocktail(Drink drink) {
        return Builder.item((Item.Properties p) -> {
            CocktailItem ret = new CocktailItem(drink, (Item.Properties)p);
            MixerRecipes.setDrinkItem(drink, ret);
            return ret;
        }, () -> Builder.getDefaultProperties().m_41503_(0).m_41487_(1).m_41495_((Item)TropicraftItems.BAMBOO_MUG.get()));
    }

    public static Supplier<AshenMaskItem> mask(AshenMasks mask) {
        return Builder.item((Item.Properties p) -> new AshenMaskItem(ArmorMaterials.ASHEN_MASK, mask, (Item.Properties)p));
    }

    public static Supplier<TropicalMusicDiscItem> musicDisc(RecordMusic type) {
        return Builder.item((Item.Properties p) -> new TropicalMusicDiscItem(type, (Item.Properties)p){}, () -> Builder.getDefaultProperties().m_41497_(Rarity.RARE));
    }

    public static <T extends Entity> Supplier<Item> spawnEgg(RegistryObject<EntityType<T>> type) {
        return Builder.item((Item.Properties p) -> new TropicraftSpawnEgg(type, (Item.Properties)p), Builder::getDefaultProperties);
    }

    public static Supplier<Item> hoe(Tier tier) {
        return Builder.item((Item.Properties p) -> new HoeItem(tier, 0, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> shovel(Tier tier) {
        return Builder.item((Item.Properties p) -> new ShovelItem(tier, 2.0f, -3.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> pickaxe(Tier tier) {
        return Builder.item((Item.Properties p) -> new PickaxeItem(tier, 2, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> axe(Tier tier) {
        return Builder.item((Item.Properties p) -> new AxeItem(tier, 5.0f, -2.0f, Builder.getDefaultProperties()));
    }

    public static Supplier<Item> sword(Tier tier) {
        return Builder.item((Item.Properties p) -> new SwordItem(tier, 3, -3.0f, Builder.getDefaultProperties()));
    }

    public static Item.Properties getDefaultProperties() {
        return new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP);
    }

    public static Supplier<Item> fireArmor(EquipmentSlot slotType) {
        return Builder.item((Item.Properties p) -> new FireArmorItem(slotType, Builder.getDefaultProperties().m_41487_(1).m_41503_(300)));
    }

    public static Supplier<Item> scaleArmor(EquipmentSlot slotType) {
        return Builder.item((Item.Properties p) -> new ScaleArmorItem(slotType, Builder.getDefaultProperties().m_41487_(1)));
    }

    public static Supplier<ScubaGogglesItem> scubaGoggles(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaGogglesItem(type, (Item.Properties)p));
    }

    public static Supplier<ScubaHarnessItem> scubaHarness(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaHarnessItem(type, (Item.Properties)p));
    }

    public static Supplier<ScubaFlippersItem> scubaFlippers(ScubaType type) {
        return Builder.item((Item.Properties p) -> new ScubaFlippersItem(type, (Item.Properties)p));
    }
}

