/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.Foods;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BambooItemFrameItem;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.Builder;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.DaggerItem;
import net.tropicraft.core.common.item.ExplodingCoconutItem;
import net.tropicraft.core.common.item.FurnitureItem;
import net.tropicraft.core.common.item.LoveTropicsShellItem;
import net.tropicraft.core.common.item.NigelStacheItem;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.SpearItem;
import net.tropicraft.core.common.item.TropicalFertilizerItem;
import net.tropicraft.core.common.item.TropicalMusicDiscItem;
import net.tropicraft.core.common.item.TropicraftToolTiers;
import net.tropicraft.core.common.item.WaterWandItem;
import net.tropicraft.core.common.item.scuba.PonyBottleItem;
import net.tropicraft.core.common.item.scuba.ScubaFlippersItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaHarnessItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TropicraftItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tropicraft");
    public static final RegistryObject<Item> AZURITE = TropicraftItems.register("azurite_gem", Builder.item());
    public static final RegistryObject<Item> EUDIALYTE = TropicraftItems.register("eudialyte_gem", Builder.item());
    public static final RegistryObject<Item> ZIRCON = TropicraftItems.register("zircon_gem", Builder.item());
    public static final RegistryObject<Item> SHAKA = TropicraftItems.register("shaka_ingot", Builder.item());
    public static final RegistryObject<Item> MANGANESE = TropicraftItems.register("manganese_ingot", Builder.item());
    public static final RegistryObject<Item> ZIRCONIUM = TropicraftItems.register("zirconium_gem", Builder.item());
    public static final Map<DyeColor, RegistryObject<FurnitureItem<UmbrellaEntity>>> UMBRELLAS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), c -> TropicraftItems.register(c.m_7912_() + "_umbrella", Builder.umbrella(c))));
    public static final Map<DyeColor, RegistryObject<FurnitureItem<ChairEntity>>> CHAIRS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), c -> TropicraftItems.register(c.m_7912_() + "_chair", Builder.chair(c))));
    public static final Map<DyeColor, RegistryObject<FurnitureItem<BeachFloatEntity>>> BEACH_FLOATS = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), c -> TropicraftItems.register(c.m_7912_() + "_beach_float", Builder.beachFloat(c))));
    public static final RegistryObject<Item> BAMBOO_STICK = TropicraftItems.register("bamboo_stick", Builder.item());
    public static final RegistryObject<Item> BAMBOO_SPEAR = TropicraftItems.register("bamboo_spear", () -> new SpearItem(TropicraftToolTiers.BAMBOO, 3, -2.4f, new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)));
    public static final RegistryObject<Item> SOLONOX_SHELL = TropicraftItems.register("solonox_shell", Builder.shell());
    public static final RegistryObject<Item> FROX_CONCH = TropicraftItems.register("frox_conch", Builder.shell());
    public static final RegistryObject<Item> PAB_SHELL = TropicraftItems.register("pab_shell", Builder.shell());
    public static final RegistryObject<Item> RUBE_NAUTILUS = TropicraftItems.register("rube_nautilus", Builder.shell());
    public static final RegistryObject<Item> STARFISH = TropicraftItems.register("starfish", Builder.shell());
    public static final RegistryObject<Item> TURTLE_SHELL = TropicraftItems.register("turtle_shell", Builder.shell());
    public static final RegistryObject<LoveTropicsShellItem> LOVE_TROPICS_SHELL = TropicraftItems.register("love_tropics_shell", () -> new LoveTropicsShellItem(new Item.Properties()));
    public static final RegistryObject<Item> LEMON = TropicraftItems.register("lemon", Builder.food(Foods.LEMON));
    public static final RegistryObject<Item> LIME = TropicraftItems.register("lime", Builder.food(Foods.LIME));
    public static final RegistryObject<Item> GRAPEFRUIT = TropicraftItems.register("grapefruit", Builder.food(Foods.GRAPEFRUIT));
    public static final RegistryObject<Item> ORANGE = TropicraftItems.register("orange", Builder.food(Foods.ORANGE));
    public static final RegistryObject<Item> PINEAPPLE_CUBES = TropicraftItems.register("pineapple_cubes", Builder.food(Foods.PINEAPPLE_CUBES));
    public static final RegistryObject<Item> COCONUT_CHUNK = TropicraftItems.register("coconut_chunk", Builder.food(Foods.COCONUT_CHUNK));
    public static final RegistryObject<ItemNameBlockItem> RAW_COFFEE_BEAN = TropicraftItems.register("raw_coffee_bean", Builder.blockNamedItem(TropicraftBlocks.COFFEE_BUSH));
    public static final RegistryObject<Item> ROASTED_COFFEE_BEAN = TropicraftItems.register("roasted_coffee_bean", Builder.item());
    public static final RegistryObject<Item> COFFEE_BERRY = TropicraftItems.register("coffee_berry", Builder.item());
    public static final RegistryObject<Item> BAMBOO_MUG = TropicraftItems.register("bamboo_mug", Builder.item());
    public static final ImmutableMap<Drink, RegistryObject<CocktailItem>> COCKTAILS = ImmutableMap.copyOf(Drink.DRINKS.values().stream().collect(Collectors.toMap(Function.identity(), d -> TropicraftItems.register(d.name, Builder.cocktail(d)))));
    public static final RegistryObject<Item> WHITE_PEARL = TropicraftItems.register("white_pearl", Builder.item());
    public static final RegistryObject<Item> BLACK_PEARL = TropicraftItems.register("black_pearl", Builder.item());
    public static final RegistryObject<Item> SCALE = TropicraftItems.register("scale", Builder.item());
    public static final RegistryObject<Item> NIGEL_STACHE = TropicraftItems.register("nigel_stache", () -> new NigelStacheItem(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)));
    public static final RegistryObject<Item> FRESH_MARLIN = TropicraftItems.register("fresh_marlin", Builder.food(Foods.FRESH_MARLIN));
    public static final RegistryObject<Item> SEARED_MARLIN = TropicraftItems.register("seared_marlin", Builder.food(Foods.SEARED_MARLIN));
    public static final RegistryObject<Item> RAW_RAY = TropicraftItems.register("raw_ray", Builder.food(Foods.RAW_RAY));
    public static final RegistryObject<Item> COOKED_RAY = TropicraftItems.register("cooked_ray", Builder.food(Foods.COOKED_RAY));
    public static final RegistryObject<Item> FROG_LEG = TropicraftItems.register("frog_leg", Builder.food(Foods.RAW_FROG_LEG));
    public static final RegistryObject<Item> COOKED_FROG_LEG = TropicraftItems.register("cooked_frog_leg", Builder.food(Foods.COOKED_FROG_LEG));
    public static final RegistryObject<Item> SEA_URCHIN_ROE = TropicraftItems.register("sea_urchin_roe", Builder.food(Foods.SEA_URCHIN_ROE));
    public static final RegistryObject<Item> TOASTED_NORI = TropicraftItems.register("toasted_nori", Builder.food(Foods.TOASTED_NORI));
    public static final RegistryObject<Item> RAW_FISH = TropicraftItems.register("raw_fish", Builder.food(Foods.RAW_FISH));
    public static final RegistryObject<Item> COOKED_FISH = TropicraftItems.register("cooked_fish", Builder.food(Foods.COOKED_FISH));
    public static final RegistryObject<Item> POISON_FROG_SKIN = TropicraftItems.register("poison_frog_skin", Builder.item());
    public static final RegistryObject<Item> IGUANA_LEATHER = TropicraftItems.register("iguana_leather", Builder.item());
    public static final RegistryObject<Item> TROPICAL_FERTILIZER = TropicraftItems.register("tropical_fertilizer", Builder.item(TropicalFertilizerItem::new));
    public static final RegistryObject<Item> BAMBOO_ITEM_FRAME = TropicraftItems.register("bamboo_item_frame", () -> new BambooItemFrameItem(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)));
    public static final ImmutableMap<RecordMusic, RegistryObject<TropicalMusicDiscItem>> MUSIC_DISCS = (ImmutableMap)Arrays.stream(RecordMusic.values()).collect(Maps.toImmutableEnumMap(Function.identity(), type -> TropicraftItems.register("music_disc_" + type.name().toLowerCase(Locale.ROOT), Builder.musicDisc(type))));
    public static final RegistryObject<Item> TROPICAL_FISH_BUCKET = TropicraftItems.register("tropical_fish_bucket", Builder.fishBucket(TropicraftEntities.TROPICAL_FISH));
    public static final RegistryObject<Item> SARDINE_BUCKET = TropicraftItems.register("sardine_bucket", Builder.fishBucket(TropicraftEntities.RIVER_SARDINE));
    public static final RegistryObject<Item> PIRANHA_BUCKET = TropicraftItems.register("piranha_bucket", Builder.fishBucket(TropicraftEntities.PIRANHA));
    public static final RegistryObject<Item> KOA_SPAWN_EGG = TropicraftItems.register("koa_spawn_egg", Builder.spawnEgg(TropicraftEntities.KOA_HUNTER));
    public static final RegistryObject<Item> TROPICREEPER_SPAWN_EGG = TropicraftItems.register("tropicreeper_spawn_egg", Builder.spawnEgg(TropicraftEntities.TROPI_CREEPER));
    public static final RegistryObject<Item> IGUANA_SPAWN_EGG = TropicraftItems.register("iguana_spawn_egg", Builder.spawnEgg(TropicraftEntities.IGUANA));
    public static final RegistryObject<Item> TROPISKELLY_SPAWN_EGG = TropicraftItems.register("tropiskelly_spawn_egg", Builder.spawnEgg(TropicraftEntities.TROPI_SKELLY));
    public static final RegistryObject<Item> EIH_SPAWN_EGG = TropicraftItems.register("eih_spawn_egg", Builder.spawnEgg(TropicraftEntities.EIH));
    public static final RegistryObject<Item> SEA_TURTLE_SPAWN_EGG = TropicraftItems.register("sea_turtle_spawn_egg", Builder.spawnEgg(TropicraftEntities.SEA_TURTLE));
    public static final RegistryObject<Item> MARLIN_SPAWN_EGG = TropicraftItems.register("marlin_spawn_egg", Builder.spawnEgg(TropicraftEntities.MARLIN));
    public static final RegistryObject<Item> FAILGULL_SPAWN_EGG = TropicraftItems.register("failgull_spawn_egg", Builder.spawnEgg(TropicraftEntities.FAILGULL));
    public static final RegistryObject<Item> DOLPHIN_SPAWN_EGG = TropicraftItems.register("dolphin_spawn_egg", Builder.spawnEgg(TropicraftEntities.DOLPHIN));
    public static final RegistryObject<Item> SEAHORSE_SPAWN_EGG = TropicraftItems.register("seahorse_spawn_egg", Builder.spawnEgg(TropicraftEntities.SEAHORSE));
    public static final RegistryObject<Item> TREE_FROG_SPAWN_EGG = TropicraftItems.register("tree_frog_spawn_egg", Builder.spawnEgg(TropicraftEntities.TREE_FROG));
    public static final RegistryObject<Item> SEA_URCHIN_SPAWN_EGG = TropicraftItems.register("sea_urchin_spawn_egg", Builder.spawnEgg(TropicraftEntities.SEA_URCHIN));
    public static final RegistryObject<Item> V_MONKEY_SPAWN_EGG = TropicraftItems.register("v_monkey_spawn_egg", Builder.spawnEgg(TropicraftEntities.V_MONKEY));
    public static final RegistryObject<Item> PIRANHA_SPAWN_EGG = TropicraftItems.register("piranha_spawn_egg", Builder.spawnEgg(TropicraftEntities.PIRANHA));
    public static final RegistryObject<Item> SARDINE_SPAWN_EGG = TropicraftItems.register("sardine_spawn_egg", Builder.spawnEgg(TropicraftEntities.RIVER_SARDINE));
    public static final RegistryObject<Item> TROPICAL_FISH_SPAWN_EGG = TropicraftItems.register("tropical_fish_spawn_egg", Builder.spawnEgg(TropicraftEntities.TROPICAL_FISH));
    public static final RegistryObject<Item> EAGLE_RAY_SPAWN_EGG = TropicraftItems.register("eagle_ray_spawn_egg", Builder.spawnEgg(TropicraftEntities.EAGLE_RAY));
    public static final RegistryObject<Item> TROPI_SPIDER_SPAWN_EGG = TropicraftItems.register("tropi_spider_spawn_egg", Builder.spawnEgg(TropicraftEntities.TROPI_SPIDER));
    public static final RegistryObject<Item> ASHEN_SPAWN_EGG = TropicraftItems.register("ashen_spawn_egg", Builder.spawnEgg(TropicraftEntities.ASHEN));
    public static final RegistryObject<Item> HAMMERHEAD_SPAWN_EGG = TropicraftItems.register("hammerhead_spawn_egg", Builder.spawnEgg(TropicraftEntities.HAMMERHEAD));
    public static final RegistryObject<Item> COWKTAIL_SPAWN_EGG = TropicraftItems.register("cowktail_spawn_egg", Builder.spawnEgg(TropicraftEntities.COWKTAIL));
    public static final RegistryObject<Item> MAN_O_WAR_SPAWN_EGG = TropicraftItems.register("man_o_war_spawn_egg", Builder.spawnEgg(TropicraftEntities.MAN_O_WAR));
    public static final RegistryObject<Item> TROPIBEE_SPAWN_EGG = TropicraftItems.register("tropibee_spawn_egg", Builder.spawnEgg(TropicraftEntities.TROPI_BEE));
    public static final RegistryObject<Item> TAPIR_SPAWN_EGG = TropicraftItems.register("tapir_spawn_egg", Builder.spawnEgg(TropicraftEntities.TAPIR));
    public static final RegistryObject<Item> JAGUAR_SPAWN_EGG = TropicraftItems.register("jaguar_spawn_egg", Builder.spawnEgg(TropicraftEntities.JAGUAR));
    public static final RegistryObject<Item> BROWN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.register("brown_basilisk_lizard_spawn_egg", Builder.spawnEgg(TropicraftEntities.BROWN_BASILISK_LIZARD));
    public static final RegistryObject<Item> GREEN_BASILISK_LIZARD_SPAWN_EGG = TropicraftItems.register("green_basilisk_lizard_spawn_egg", Builder.spawnEgg(TropicraftEntities.GREEN_BASILISK_LIZARD));
    public static final RegistryObject<Item> HUMMINGBIRD_SPAWN_EGG = TropicraftItems.register("hummingbird_spawn_egg", Builder.spawnEgg(TropicraftEntities.HUMMINGBIRD));
    public static final RegistryObject<Item> FIDDLER_CRAB_SPAWN_EGG = TropicraftItems.register("fiddler_crab_spawn_egg", Builder.spawnEgg(TropicraftEntities.FIDDLER_CRAB));
    public static final RegistryObject<Item> SPIDER_MONKEY_SPAWN_EGG = TropicraftItems.register("spider_monkey_spawn_egg", Builder.spawnEgg(TropicraftEntities.SPIDER_MONKEY));
    public static final RegistryObject<Item> WHITE_LIPPED_PECCARY_SPAWN_EGG = TropicraftItems.register("white_lipped_peccary_spawn_egg", Builder.spawnEgg(TropicraftEntities.WHITE_LIPPED_PECCARY));
    public static final RegistryObject<Item> CUBERA_SPAWN_EGG = TropicraftItems.register("cubera_spawn_egg", Builder.spawnEgg(TropicraftEntities.CUBERA));
    public static final ImmutableMap<AshenMasks, RegistryObject<AshenMaskItem>> ASHEN_MASKS = (ImmutableMap)Arrays.stream(AshenMasks.values()).collect(Maps.toImmutableEnumMap(Function.identity(), type -> TropicraftItems.register("ashen_mask_" + type.name().toLowerCase(Locale.ROOT), Builder.mask(type))));
    public static final RegistryObject<Item> DAGGER = TropicraftItems.register("dagger", () -> new DaggerItem(TropicraftToolTiers.ZIRCON, new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP).m_41487_(1)));
    public static final RegistryObject<Item> BLOW_GUN = TropicraftItems.register("blow_gun", () -> new BlowGunItem(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP).m_41487_(1)));
    public static final RegistryObject<Item> ZIRCON_HOE = TropicraftItems.register("zircon_hoe", Builder.hoe(TropicraftToolTiers.ZIRCON));
    public static final RegistryObject<Item> ZIRCONIUM_HOE = TropicraftItems.register("zirconium_hoe", Builder.hoe(TropicraftToolTiers.ZIRCONIUM));
    public static final RegistryObject<Item> EUDIALYTE_HOE = TropicraftItems.register("eudialyte_hoe", Builder.hoe(TropicraftToolTiers.EUDIALYTE));
    public static final RegistryObject<Item> ZIRCON_AXE = TropicraftItems.register("zircon_axe", Builder.axe(TropicraftToolTiers.ZIRCON));
    public static final RegistryObject<Item> ZIRCONIUM_AXE = TropicraftItems.register("zirconium_axe", Builder.axe(TropicraftToolTiers.ZIRCONIUM));
    public static final RegistryObject<Item> EUDIALYTE_AXE = TropicraftItems.register("eudialyte_axe", Builder.axe(TropicraftToolTiers.EUDIALYTE));
    public static final RegistryObject<Item> ZIRCON_PICKAXE = TropicraftItems.register("zircon_pickaxe", Builder.pickaxe(TropicraftToolTiers.ZIRCON));
    public static final RegistryObject<Item> ZIRCONIUM_PICKAXE = TropicraftItems.register("zirconium_pickaxe", Builder.pickaxe(TropicraftToolTiers.ZIRCONIUM));
    public static final RegistryObject<Item> EUDIALYTE_PICKAXE = TropicraftItems.register("eudialyte_pickaxe", Builder.pickaxe(TropicraftToolTiers.EUDIALYTE));
    public static final RegistryObject<Item> ZIRCON_SHOVEL = TropicraftItems.register("zircon_shovel", Builder.shovel(TropicraftToolTiers.ZIRCON));
    public static final RegistryObject<Item> ZIRCONIUM_SHOVEL = TropicraftItems.register("zirconium_shovel", Builder.shovel(TropicraftToolTiers.ZIRCONIUM));
    public static final RegistryObject<Item> EUDIALYTE_SHOVEL = TropicraftItems.register("eudialyte_shovel", Builder.shovel(TropicraftToolTiers.EUDIALYTE));
    public static final RegistryObject<Item> ZIRCON_SWORD = TropicraftItems.register("zircon_sword", Builder.sword(TropicraftToolTiers.ZIRCON));
    public static final RegistryObject<Item> ZIRCONIUM_SWORD = TropicraftItems.register("zirconium_sword", Builder.sword(TropicraftToolTiers.ZIRCONIUM));
    public static final RegistryObject<Item> EUDIALYTE_SWORD = TropicraftItems.register("eudialyte_sword", Builder.sword(TropicraftToolTiers.EUDIALYTE));
    public static final RegistryObject<Item> FIRE_BOOTS = TropicraftItems.register("fire_boots", Builder.fireArmor(EquipmentSlot.FEET));
    public static final RegistryObject<Item> FIRE_LEGGINGS = TropicraftItems.register("fire_leggings", Builder.fireArmor(EquipmentSlot.LEGS));
    public static final RegistryObject<Item> FIRE_CHESTPLATE = TropicraftItems.register("fire_chestplate", Builder.fireArmor(EquipmentSlot.CHEST));
    public static final RegistryObject<Item> FIRE_HELMET = TropicraftItems.register("fire_helmet", Builder.fireArmor(EquipmentSlot.HEAD));
    public static final RegistryObject<Item> SCALE_BOOTS = TropicraftItems.register("scale_boots", Builder.scaleArmor(EquipmentSlot.FEET));
    public static final RegistryObject<Item> SCALE_LEGGINGS = TropicraftItems.register("scale_leggings", Builder.scaleArmor(EquipmentSlot.LEGS));
    public static final RegistryObject<Item> SCALE_CHESTPLATE = TropicraftItems.register("scale_chestplate", Builder.scaleArmor(EquipmentSlot.CHEST));
    public static final RegistryObject<Item> SCALE_HELMET = TropicraftItems.register("scale_helmet", Builder.scaleArmor(EquipmentSlot.HEAD));
    public static final RegistryObject<ScubaGogglesItem> YELLOW_SCUBA_GOGGLES = TropicraftItems.register("yellow_scuba_goggles", Builder.scubaGoggles(ScubaType.YELLOW));
    public static final RegistryObject<ScubaHarnessItem> YELLOW_SCUBA_HARNESS = TropicraftItems.register("yellow_scuba_harness", Builder.scubaHarness(ScubaType.YELLOW));
    public static final RegistryObject<ScubaFlippersItem> YELLOW_SCUBA_FLIPPERS = TropicraftItems.register("yellow_scuba_flippers", Builder.scubaFlippers(ScubaType.YELLOW));
    public static final RegistryObject<ScubaGogglesItem> PINK_SCUBA_GOGGLES = TropicraftItems.register("pink_scuba_goggles", Builder.scubaGoggles(ScubaType.PINK));
    public static final RegistryObject<ScubaHarnessItem> PINK_SCUBA_HARNESS = TropicraftItems.register("pink_scuba_harness", Builder.scubaHarness(ScubaType.PINK));
    public static final RegistryObject<ScubaFlippersItem> PINK_SCUBA_FLIPPERS = TropicraftItems.register("pink_scuba_flippers", Builder.scubaFlippers(ScubaType.PINK));
    public static final RegistryObject<PonyBottleItem> YELLOW_PONY_BOTTLE = TropicraftItems.register("yellow_pony_bottle", Builder.item(PonyBottleItem::new, Builder.getDefaultProperties().m_41487_(1).m_41503_(32)));
    public static final RegistryObject<PonyBottleItem> PINK_PONY_BOTTLE = TropicraftItems.register("pink_pony_bottle", Builder.item(PonyBottleItem::new, Builder.getDefaultProperties().m_41487_(1).m_41503_(32)));
    public static final RegistryObject<Item> WATER_WAND = TropicraftItems.register("water_wand", () -> new WaterWandItem(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP).m_41487_(1).m_41503_(2000)));
    public static final RegistryObject<Item> EXPLODING_COCONUT = TropicraftItems.register("exploding_coconut", () -> new ExplodingCoconutItem(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)));
    public static final RegistryObject<Item> FISHING_NET = TropicraftItems.register("fishing_net", () -> new Item(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP).m_41487_(1)));
    public static final RegistryObject<Item> PIANGUAS = TropicraftItems.register("pianguas", () -> new Item(new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)));

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ITEMS.register(name, sup);
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b instanceof FlowerPotBlock).map(b -> (FlowerPotBlock)b).forEach(b -> {
            if (b.getEmptyPot().getRegistryName().equals((Object)TropicraftBlocks.BAMBOO_FLOWER_POT.getId()) && b.getEmptyPot() != b) {
                TropicraftItems.addPlant((FlowerPotBlock)TropicraftBlocks.BAMBOO_FLOWER_POT.get(), b);
            } else if (b.m_53560_().getRegistryName().m_135827_().equals("tropicraft")) {
                TropicraftItems.addPlant((FlowerPotBlock)Blocks.f_50276_, b);
            }
        });
    }

    private static void addPlant(FlowerPotBlock empty, FlowerPotBlock full) {
        empty.addPlant(full.m_53560_().getRegistryName(), (Supplier)full.delegate);
    }
}

