/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.client.scuba.ScubaHUD;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaHarnessItem
extends ScubaArmorItem {
    public ScubaHarnessItem(ScubaType type, Item.Properties properties) {
        super(type, EquipmentSlot.CHEST, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int airRemaining = this.getRemainingAir(stack);
        tooltip.add((Component)TropicraftLangKeys.SCUBA_AIR_TIME.format(new TextComponent(ScubaHUD.formatTime(airRemaining)).m_130940_(ScubaHUD.getAirTimeColor(airRemaining, worldIn))).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public boolean providesAir() {
        return true;
    }

    @Override
    public void tickAir(Player player, EquipmentSlot slot, ItemStack stack) {
        if (player.f_19853_.f_46443_ || player.m_150110_().f_35937_) {
            return;
        }
        CompoundTag scubaData = stack.m_41698_("scuba");
        int remaining = this.getRemainingAir(stack);
        if (remaining > 0) {
            scubaData.m_128405_("air", remaining - 1);
            player.m_20301_(player.m_6062_());
        }
    }

    @Override
    public int addAir(int air, ItemStack stack) {
        if (air > 0) {
            int current = this.getRemainingAir(stack);
            int max = this.getMaxAir(stack);
            int newAir = Math.min(current + air, max);
            stack.m_41698_("scuba").m_128405_("air", newAir);
            return air - (newAir - current);
        }
        return 0;
    }

    @Override
    public int getRemainingAir(ItemStack stack) {
        return stack.m_41698_("scuba").m_128451_("air");
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        return 12000;
    }

    public static void handleUnderwaterBreathing(TickEvent.PlayerTickEvent event) {
    }
}

