/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import com.google.common.reflect.TypeToken;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.tropicraft.core.common.network.TropicraftMessage;

public abstract class MessageTileEntity<T extends BlockEntity>
implements TropicraftMessage {
    protected long pos;
    @Deprecated
    protected int x;
    @Deprecated
    protected int y;
    @Deprecated
    protected int z;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.pos = tile.m_58899_().m_121878_();
    }

    protected static void encode(MessageTileEntity<?> message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos);
    }

    protected static void decode(MessageTileEntity<?> message, FriendlyByteBuf buf) {
        message.pos = buf.readLong();
        BlockPos bp = message.getPos();
        message.x = bp.m_123341_();
        message.y = bp.m_123342_();
        message.z = bp.m_123343_();
    }

    public BlockPos getPos() {
        return BlockPos.m_122022_((long)this.pos);
    }

    protected T getClientTileEntity() {
        return this.getTileEntity((Level)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91073_));
    }

    protected T getTileEntity(Level worldObj) {
        if (worldObj == null || !worldObj.m_46805_(this.getPos())) {
            return null;
        }
        BlockEntity te = worldObj.m_7702_(this.getPos());
        if (te == null) {
            return null;
        }
        TypeToken teType = TypeToken.of(this.getClass()).resolveType(MessageTileEntity.class.getTypeParameters()[0]);
        if (teType.isSubtypeOf(te.getClass())) {
            return (T)te;
        }
        return null;
    }
}

