/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.tutorials.repack.ltlib.backend;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lovetropics.tutorials.repack.ltlib.backend.BackendConnection;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;

public final class BackendWebSocketConnection
extends SimpleChannelInboundHandler<WebSocketFrame>
implements BackendConnection {
    private static final EventLoopGroup EVENT_LOOP_GROUP = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setNameFormat("lt-backend-event-loop").setDaemon(true).build());
    private static final int TIMEOUT_SECONDS = 30;
    private static final int MAX_FRAME_SIZE = 0x1000000;
    private static final Gson GSON = new Gson();
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final BackendConnection.Handler handler;
    private final ConcurrentLinkedQueue<String> writeQueue = new ConcurrentLinkedQueue();
    private final AtomicBoolean scheduledWrite = new AtomicBoolean(false);
    private Channel channel;

    private BackendWebSocketConnection(BackendConnection.Handler handler) {
        this.handler = handler;
    }

    public static CompletableFuture<BackendWebSocketConnection> connect(final URI address, BackendConnection.Handler handler) {
        SslContext ssl;
        if (!address.getScheme().equals("wss")) {
            throw new IllegalArgumentException("Backend connection requires wss protocol!");
        }
        final BackendWebSocketConnection connection = new BackendWebSocketConnection(handler);
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        try {
            ssl = SslContextBuilder.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)address, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)headers, (int)0x1000000);
        final WebSocketClientProtocolHandler websocket = new WebSocketClientProtocolHandler(handshaker);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(EVENT_LOOP_GROUP);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new WriteTimeoutHandler(30)}).addLast(new ChannelHandler[]{ssl.newHandler(channel.alloc(), address.getHost(), address.getPort())}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x1000000)}).addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE}).addLast(new ChannelHandler[]{websocket}).addLast(new ChannelHandler[]{connection});
            }
        });
        CompletableFuture<Channel> future = BackendWebSocketConnection.awaitFuture(bootstrap.connect(address.getHost(), address.getPort()));
        future.handle((connected, error) -> {
            if (connected != null) {
                connection.channel = connected;
                connection.handler.acceptOpened();
            } else {
                connection.handler.acceptError((Throwable)error);
            }
            return null;
        });
        return future.thenApply(c -> connection);
    }

    private static CompletableFuture<Channel> awaitFuture(ChannelFuture channelFuture) {
        CompletableFuture<Channel> completableFuture = new CompletableFuture<Channel>();
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)result -> {
            if (result.isSuccess()) {
                completableFuture.complete(result.channel());
            } else {
                Throwable cause = result.cause();
                completableFuture.completeExceptionally(cause);
            }
        }));
        return completableFuture;
    }

    public void ping() {
        EVENT_LOOP_GROUP.execute(() -> this.channel.writeAndFlush((Object)new PingWebSocketFrame()));
    }

    @Override
    public boolean send(JsonObject payload) {
        String text = GSON.toJson((JsonElement)payload);
        this.writeQueue.add(text);
        if (this.scheduledWrite.compareAndSet(false, true)) {
            EVENT_LOOP_GROUP.execute(this::writeQueued);
        }
        return true;
    }

    private void writeQueued() {
        this.scheduledWrite.set(false);
        ConcurrentLinkedQueue<String> writeQueue = this.writeQueue;
        if (!writeQueue.isEmpty()) {
            String message;
            Channel channel = this.channel;
            while ((message = writeQueue.poll()) != null) {
                ChannelFuture future = channel.write((Object)new TextWebSocketFrame(message));
                future.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            channel.flush();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            this.acceptTextFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            this.acceptCloseFrame((CloseWebSocketFrame)frame);
        }
    }

    private void acceptTextFrame(TextWebSocketFrame textFrame) {
        JsonObject payload = JSON_PARSER.parse(textFrame.text()).getAsJsonObject();
        this.handler.acceptMessage(payload);
    }

    private void acceptCloseFrame(CloseWebSocketFrame closeFrame) {
        if (this.channel != null) {
            this.handler.acceptClosed(closeFrame.statusCode(), closeFrame.reasonText());
            this.channel = null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.channel != null) {
            this.handler.acceptError(cause);
            this.channel.writeAndFlush((Object)new CloseWebSocketFrame());
            ctx.close();
            this.channel = null;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channel != null) {
            this.handler.acceptClosed(-1, null);
            this.channel = null;
        }
    }

    @Override
    public boolean isConnected() {
        return this.channel != null;
    }
}

