/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.tutorials.repack.ltlib.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class MoreCodecs {
    public static final Codec<ItemStack> ITEM_STACK = Codec.either((Codec)ItemStack.f_41582_, (Codec)Registry.f_122827_.m_194605_()).xmap(either -> (ItemStack)either.map(Function.identity(), ItemStack::new), Either::left);
    public static final Codec<BlockState> BLOCK_STATE = Codec.either((Codec)BlockState.f_61039_, (Codec)Registry.f_122824_.m_194605_()).xmap(either -> (BlockState)either.map(Function.identity(), Block::m_49966_), Either::left);
    public static final Codec<BlockStateProvider> BLOCK_STATE_PROVIDER = Codec.either((Codec)BlockStateProvider.f_68747_, BLOCK_STATE).xmap(either -> (BlockStateProvider)either.map(Function.identity(), BlockStateProvider::m_191384_), Either::left);
    public static final Codec<Component> TEXT = MoreCodecs.withJson(Component.Serializer::m_130716_, json -> {
        MutableComponent text = Component.Serializer.m_130691_((JsonElement)json);
        return text != null ? DataResult.success((Object)text) : DataResult.error((String)"Malformed text");
    });
    public static final Codec<DyeColor> DYE_COLOR = MoreCodecs.stringVariants(DyeColor.values(), DyeColor::m_7912_);
    public static final Codec<EquipmentSlot> EQUIPMENT_SLOT = MoreCodecs.stringVariants(EquipmentSlot.values(), EquipmentSlot::m_20751_);
    public static final Codec<ChatFormatting> FORMATTING = MoreCodecs.stringVariants(ChatFormatting.values(), ChatFormatting::m_126666_);
    public static final Codec<TextColor> COLOR = Codec.STRING.comapFlatMap(name -> {
        TextColor color = TextColor.m_131268_((String)name);
        return color != null ? DataResult.success((Object)color) : DataResult.error((String)"Invalid color format");
    }, TextColor::toString);
    public static final Codec<GameType> GAME_TYPE = MoreCodecs.stringVariants(GameType.values(), GameType::m_46405_);
    public static final Codec<UUID> UUID_STRING = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)"Malformed UUID!");
        }
    }, UUID::toString);
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = MoreCodecs.withJson(BlockPredicate::m_17913_, json -> {
        try {
            return DataResult.success((Object)BlockPredicate.m_17917_((JsonElement)json));
        }
        catch (JsonSyntaxException e) {
            return DataResult.error((String)e.getMessage());
        }
    });
    public static final Codec<Vec3> VECTOR_3D = Codec.DOUBLE.listOf().comapFlatMap(doubles -> {
        if (doubles.size() == 3) {
            return DataResult.success((Object)new Vec3(((Double)doubles.get(0)).doubleValue(), ((Double)doubles.get(1)).doubleValue(), ((Double)doubles.get(2)).doubleValue()));
        }
        return DataResult.error((String)"Wrong number of vector components!");
    }, vector -> ImmutableList.of((Object)vector.f_82479_, (Object)vector.f_82480_, (Object)vector.f_82481_));
    public static final Codec<Vector3f> VECTOR_3F = Codec.FLOAT.listOf().comapFlatMap(floats -> {
        if (floats.size() == 3) {
            return DataResult.success((Object)new Vector3f(((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), ((Float)floats.get(2)).floatValue()));
        }
        return DataResult.error((String)"Wrong number of vector components!");
    }, vector -> ImmutableList.of((Object)Float.valueOf(vector.m_122239_()), (Object)Float.valueOf(vector.m_122260_()), (Object)Float.valueOf(vector.m_122269_())));
    public static final Codec<AABB> AABB = RecordCodecBuilder.create(instance -> instance.group((App)VECTOR_3D.fieldOf("start").forGetter(aabb -> new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_)), (App)VECTOR_3D.fieldOf("end").forGetter(aabb -> new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_))).apply((Applicative)instance, AABB::new));
    public static final Codec<Difficulty> DIFFICULTY = MoreCodecs.stringVariants(Difficulty.values(), Difficulty::m_19036_);
    public static final Codec<Potion> POTION = Registry.f_122828_.m_194605_();
    private static final Codec<MobEffectInstance> EFFECT_INSTANCE_RECORD = RecordCodecBuilder.create(i -> i.group((App)Registry.f_122823_.m_194605_().fieldOf("type").forGetter(MobEffectInstance::m_19544_), (App)Codec.FLOAT.fieldOf("seconds").forGetter(c -> Float.valueOf((float)c.m_19557_() / 20.0f)), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("hide_particles", (Object)false).forGetter(c -> !c.m_19572_())).apply((Applicative)i, (type, seconds, amplifier, hideParticles) -> new MobEffectInstance(type, Math.round(seconds.floatValue() * 20.0f), amplifier.intValue(), false, hideParticles.booleanValue())));
    public static final Codec<MobEffectInstance> EFFECT_INSTANCE = Codec.either(POTION, EFFECT_INSTANCE_RECORD).comapFlatMap(either -> (DataResult)either.map(potion -> {
        List effects = potion.m_43488_();
        if (effects.size() == 1) {
            return DataResult.success((Object)((MobEffectInstance)effects.get(0)));
        }
        return DataResult.error((String)"Potion must have only 1 effect");
    }, DataResult::success), Either::right);

    public static <T> MapCodec<T> inputOptionalFieldOf(Codec<T> codec, String name, T fallback) {
        return Codec.optionalField((String)name, codec).xmap(o -> o.orElse(fallback), Optional::of);
    }

    public static <T> Codec<T[]> arrayOrUnit(Codec<T> codec, IntFunction<T[]> factory) {
        return MoreCodecs.listToArray(MoreCodecs.listOrUnit(codec), factory);
    }

    public static <T> Codec<List<T>> listOrUnit(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), MoreCodecs::unitArrayList), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left((Object)list));
    }

    public static <T> Codec<T[]> listToArray(Codec<List<T>> codec, IntFunction<T[]> factory) {
        return codec.xmap(list -> list.toArray((Object[])factory.apply(0)), Arrays::asList);
    }

    public static <A> Codec<A> stringVariants(A[] values, Function<A, String> asName) {
        return MoreCodecs.keyedVariants(values, asName, Codec.STRING);
    }

    public static <A, K> Codec<A> keyedVariants(A[] values, Function<A, K> asKey, Codec<K> keyCodec) {
        Object2ObjectOpenHashMap byKey = new Object2ObjectOpenHashMap();
        for (A value : values) {
            byKey.put(asKey.apply(value), value);
        }
        return keyCodec.comapFlatMap(arg_0 -> MoreCodecs.lambda$keyedVariants$24((Map)byKey, arg_0), asKey);
    }

    public static <A> Codec<A> withJson(Function<A, JsonElement> encode, Function<JsonElement, DataResult<A>> decode) {
        return MoreCodecs.withOps(JsonOps.INSTANCE, encode, decode);
    }

    public static <A> Codec<A> withNbt(Function<A, Tag> encode, Function<Tag, DataResult<A>> decode) {
        return MoreCodecs.withOps(NbtOps.f_128958_, encode, decode);
    }

    public static <A> Codec<A> withNbtCompound(BiFunction<A, CompoundTag, CompoundTag> encode, BiConsumer<A, CompoundTag> decode, Supplier<A> factory) {
        return MoreCodecs.withNbt(value -> (Tag)encode.apply(value, new CompoundTag()), nbt -> {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                Object value = factory.get();
                decode.accept(value, compound);
                return DataResult.success(value);
            }
            return DataResult.error((String)"Expected compound tag");
        });
    }

    public static <A, T> Codec<A> withOps(DynamicOps<T> ops, Function<A, T> encode, Function<T, DataResult<A>> decode) {
        return new MappedOpsCodec<A, T>(ops, encode, decode);
    }

    public static <N extends Number> Codec<N> numberAsString(Function<String, N> parse) {
        return Codec.STRING.comapFlatMap(s -> {
            try {
                return DataResult.success((Object)((Number)parse.apply((String)s)));
            }
            catch (NumberFormatException e) {
                return DataResult.error((String)("Failed to parse number '" + s + "'"));
            }
        }, Object::toString);
    }

    public static <V> Codec<Long2ObjectMap<V>> long2Object(Codec<V> codec) {
        return Codec.unboundedMap(MoreCodecs.numberAsString(Long::parseLong), codec).xmap(Long2ObjectOpenHashMap::new, HashMap::new);
    }

    public static <K> Codec<Object2FloatMap<K>> object2Float(Codec<K> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.FLOAT).xmap(Object2FloatOpenHashMap::new, HashMap::new);
    }

    public static <K> Codec<Object2DoubleMap<K>> object2Double(Codec<K> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.DOUBLE).xmap(Object2DoubleOpenHashMap::new, HashMap::new);
    }

    public static <T> Codec<ResourceKey<T>> resourceKey(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.f_135803_.xmap(id -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)id), ResourceKey::m_135782_);
    }

    public static <T, C extends List<T>> Codec<C> sorted(Codec<C> codec, Comparator<? super T> comparator) {
        return codec.xmap(list -> {
            list.sort(comparator);
            return list;
        }, Function.identity());
    }

    public static <K, V> Codec<Map<K, V>> dispatchByMapKey(Codec<K> keyCodec, Function<K, Codec<V>> valueCodec) {
        return new DispatchMapCodec<K, V>(keyCodec, valueCodec);
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<T> ofForgeRegistry(final Supplier<IForgeRegistry<T>> registry) {
        return new Codec<T>(){

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                return ResourceLocation.f_135803_.decode(ops, input).flatMap(arg_0 -> 1.lambda$decode$0((Supplier)registry, arg_0));
            }

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                ResourceLocation key = ((IForgeRegistry)registry.get()).getKey(input);
                if (key == null) {
                    return DataResult.error((String)("Unknown registry element " + input));
                }
                return ops.mergeToPrimitive(prefix, ops.createString(key.toString()));
            }

            private static /* synthetic */ DataResult lambda$decode$0(Supplier registry2, Pair pair) {
                if (!((IForgeRegistry)registry2.get()).containsKey((ResourceLocation)pair.getFirst())) {
                    return DataResult.error((String)("Unknown registry key: " + pair.getFirst()));
                }
                return DataResult.success((Object)pair.mapFirst(arg_0 -> ((IForgeRegistry)((IForgeRegistry)registry2.get())).getValue(arg_0)));
            }
        };
    }

    public static <T> Codec<T> validate(Codec<T> codec, Function<T, DataResult<T>> validate) {
        return codec.flatXmap(validate, validate);
    }

    public static <T> Codec<T> validate(Codec<T> codec, Predicate<T> validate, String error) {
        return MoreCodecs.validate(codec, value -> {
            if (validate.test(value)) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)error);
        });
    }

    public static Codec<LocalDateTime> localDateTime(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)LocalDateTime.parse(string, formatter));
            }
            catch (DateTimeParseException e) {
                return DataResult.error((String)("Failed to parse date: " + string));
            }
        }, formatter::format);
    }

    public static <T> Codec<T> tryFirst(Codec<T> first, Codec<T> second) {
        return new TryFirstCodec<T>(first, second);
    }

    private static <T> List<T> unitArrayList(T t) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(t);
        return list;
    }

    private static /* synthetic */ DataResult lambda$keyedVariants$24(Map byKey, Object key) {
        Object value = byKey.get(key);
        return value != null ? DataResult.success(value) : DataResult.error((String)("No variant with key '" + key + "'"));
    }

    record MappedOpsCodec<A, S>(DynamicOps<S> sourceOps, Function<A, S> encode, Function<S, DataResult<A>> decode) implements Codec<A>
    {
        public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
            S sourceData = this.encode.apply(input);
            S targetData = ops == this.sourceOps ? sourceData : this.sourceOps.convertTo(ops, sourceData);
            return ops.getMap(targetData).flatMap(map -> ops.mergeToMap(prefix, map));
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
            Object sourceData = ops == this.sourceOps ? input : ops.convertTo(this.sourceOps, input);
            return this.decode.apply(sourceData).map(output -> Pair.of((Object)output, (Object)input));
        }
    }

    record DispatchMapCodec<K, V>(Codec<K> keyCodec, Function<K, Codec<V>> valueCodec) implements Codec<Map<K, V>>
    {
        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).flatMap(mapInput -> {
                ImmutableMap.Builder read = ImmutableMap.builder();
                ImmutableList.Builder failed = ImmutableList.builder();
                DataResult result = mapInput.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> this.keyCodec.parse(ops, pair.getFirst()).flatMap(key -> {
                    DataResult entry = this.valueCodec.apply(key).parse(ops, pair.getSecond()).map(value -> Pair.of((Object)key, (Object)value));
                    entry.error().ifPresent(e -> failed.add(pair));
                    return r.apply2stable((u, p) -> {
                        read.put(p.getFirst(), p.getSecond());
                        return u;
                    }, entry);
                }), (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
                ImmutableMap elements = read.build();
                Object errors = ops.createMap(failed.build().stream());
                return result.map(arg_0 -> DispatchMapCodec.lambda$decode$7((Map)elements, input, arg_0)).setPartial((Object)Pair.of((Object)elements, (Object)input)).mapError(e -> e + " missed input: " + errors);
            });
        }

        public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder map = ops.mapBuilder();
            for (Map.Entry<K, V> entry : input.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                map.add(this.keyCodec.encodeStart(ops, key), this.valueCodec.apply(key).encodeStart(ops, value));
            }
            return map.build(prefix);
        }

        private static /* synthetic */ Pair lambda$decode$7(Map elements, Object input, Unit unit) {
            return Pair.of((Object)elements, (Object)input);
        }
    }

    record TryFirstCodec<T>(Codec<T> first, Codec<T> second) implements Codec<T>
    {
        public <R> DataResult<Pair<T, R>> decode(DynamicOps<R> ops, R input) {
            DataResult firstRead = this.first.decode(ops, input);
            if (firstRead.result().isPresent()) {
                return firstRead;
            }
            return this.second.decode(ops, input);
        }

        public <R> DataResult<R> encode(T input, DynamicOps<R> ops, R prefix) {
            return this.second.encode(input, ops, prefix);
        }
    }
}

