/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.network.SendTutorialsMessage;
import org.lovetropics.tutorials.network.TutorialsNetwork;

@Mod.EventBusSubscriber(modid="lttutorials")
public final class ServerTutorials {
    private static final Logger LOGGER = LogManager.getLogger(ServerTutorials.class);
    private static final JsonParser PARSER = new JsonParser();
    private static List<TutorialConfig> tutorials = new ArrayList<TutorialConfig>();
    private static boolean changed;

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> {
            CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                ArrayList tutorials = new ArrayList();
                Collection paths = resourceManager.m_6540_("tutorials", file -> file.endsWith(".json"));
                for (ResourceLocation path : paths) {
                    try {
                        Resource resource = resourceManager.m_142591_(path);
                        try {
                            DataResult<TutorialConfig> result = ServerTutorials.loadTutorial(resource);
                            result.result().ifPresent(tutorials::add);
                            result.error().ifPresent(error -> LOGGER.error("Failed to load tutorial config at {}: {}", (Object)path, error));
                        }
                        finally {
                            if (resource == null) continue;
                            resource.close();
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to load tutorial config at {}", (Object)path, (Object)e);
                    }
                }
                return tutorials;
            }, backgroundExecutor);
            return ((CompletableFuture)future.thenAcceptAsync(ServerTutorials::setTutorials, gameExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        });
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerTutorials.sendTutorialsTo((ServerPlayer)player, tutorials);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!changed) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && event.world.m_46472_() == Level.f_46428_) {
            MinecraftServer server = event.world.m_142572_();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ServerTutorials.sendTutorialsTo(player, tutorials);
            }
            changed = false;
        }
    }

    private static void setTutorials(List<TutorialConfig> tutorials) {
        ServerTutorials.tutorials = tutorials;
        changed = true;
    }

    private static void sendTutorialsTo(ServerPlayer player, List<TutorialConfig> tutorials) {
        TutorialsNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendTutorialsMessage(tutorials));
    }

    private static DataResult<TutorialConfig> loadTutorial(Resource resource) throws IOException {
        try (InputStream input = resource.m_6679_();){
            JsonElement json = PARSER.parse((Reader)new BufferedReader(new InputStreamReader(input)));
            DataResult dataResult = TutorialConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return dataResult;
        }
    }
}

