/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials;

import com.lovetropics.tutorials.repack.ltlib.BlockBox;
import com.lovetropics.tutorials.repack.ltlib.codec.CodecRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public interface TutorialSpace {
    public static final CodecRegistry<String, Codec<? extends TutorialSpace>> REGISTRY = CodecRegistry.stringKeys();
    public static final Codec<TutorialSpace> CODEC = REGISTRY.dispatchStable(TutorialSpace::getCodec, Function.identity());

    public static void register() {
        REGISTRY.register("box", Box.CODEC);
    }

    public void addToIndex(Indexer var1);

    public boolean contains(ResourceKey<Level> var1, BlockPos var2);

    public Codec<? extends TutorialSpace> getCodec();

    public static final class Box
    implements TutorialSpace {
        public static final Codec<Box> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("dimension").forGetter(c -> c.dimension), (App)BlockBox.CODEC.fieldOf("box").forGetter(c -> c.box)).apply((Applicative)instance, Box::new));
        private final ResourceKey<Level> dimension;
        private final BlockBox box;

        public Box(ResourceKey<Level> dimension, BlockBox box) {
            this.dimension = dimension;
            this.box = box;
        }

        @Override
        public void addToIndex(Indexer indexer) {
            SectionPos minSection = SectionPos.m_123199_((BlockPos)this.box.min());
            SectionPos maxSection = SectionPos.m_123199_((BlockPos)this.box.max());
            for (int z = minSection.m_123222_(); z <= maxSection.m_123222_(); ++z) {
                for (int y = minSection.m_123206_(); y <= maxSection.m_123206_(); ++y) {
                    for (int x = minSection.m_123170_(); x <= maxSection.m_123170_(); ++x) {
                        indexer.accept(this.dimension, SectionPos.m_123209_((int)x, (int)y, (int)z));
                    }
                }
            }
        }

        @Override
        public boolean contains(ResourceKey<Level> dimension, BlockPos pos) {
            return this.dimension == dimension && this.box.contains(pos);
        }

        @Override
        public Codec<? extends TutorialSpace> getCodec() {
            return CODEC;
        }
    }

    public static interface Indexer {
        public void accept(ResourceKey<Level> var1, long var2);
    }
}

