/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.client.TutorialClientState;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderers;
import org.lovetropics.tutorials.widget.TutorialWidget;

@Mod.EventBusSubscriber(modid="lttutorials", value={Dist.CLIENT})
public final class TutorialRenderManager {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static DisplayState displayState;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = TutorialRenderManager.CLIENT.f_91074_;
        if (event.phase == TickEvent.Phase.END || player == null) {
            return;
        }
        DisplayState displayState = TutorialRenderManager.getDisplayState();
        if (displayState != null) {
            Entity camera = CLIENT.m_91288_();
            if (camera == null) {
                camera = player;
            }
            displayState.tick(camera);
        }
    }

    @Nullable
    private static DisplayState getDisplayState() {
        TutorialClientState clientState = TutorialClientState.get();
        DisplayState displayState = TutorialRenderManager.displayState;
        if (clientState != null && displayState == null || displayState != null && displayState.clientState != clientState) {
            TutorialRenderManager.displayState = displayState = new DisplayState(clientState);
        } else if (clientState == null && displayState != null) {
            TutorialRenderManager.displayState = null;
        }
        return displayState;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelLastEvent event) {
        DisplayState displayState = TutorialRenderManager.displayState;
        if (displayState == null) {
            return;
        }
        Camera camera = TutorialRenderManager.CLIENT.f_91063_.m_109153_();
        if (!camera.m_90593_()) {
            return;
        }
        for (Reference2IntMap.Entry entry : Reference2IntMaps.fastIterable(displayState.visible)) {
            TutorialConfig tutorial = (TutorialConfig)entry.getKey();
            List<TutorialWidget> widgets = tutorial.getWidgets();
            float animation = (float)entry.getIntValue() / 10.0f;
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.renderWidget(widget, event.getLevelRenderer(), event.getPoseStack(), camera, event.getPartialTick(), animation);
            }
        }
    }

    public static <T extends TutorialWidget> void renderWidget(T widget, LevelRenderer context, PoseStack matrixStack, Camera camera, float partialTicks, float animation) {
        if (animation <= 0.01f) {
            return;
        }
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.render(widget, context, matrixStack, camera, partialTicks, animation);
        }
    }

    public static <T extends TutorialWidget> void tickWidget(T widget, Entity camera) {
        TutorialWidgetRenderer<T> renderer = TutorialWidgetRenderers.rendererFor(widget);
        if (renderer != null) {
            renderer.tick(widget, camera);
        }
    }

    static final class DisplayState {
        private static final int ANIMATION_TICKS = 10;
        private final TutorialClientState clientState;
        private final Set<TutorialConfig> active = new ReferenceOpenHashSet();
        private final Reference2IntMap<TutorialConfig> visible = new Reference2IntOpenHashMap();
        private BlockPos lastPlayerPos;

        DisplayState(TutorialClientState clientState) {
            this.clientState = clientState;
        }

        void tick(Entity camera) {
            Set<TutorialConfig> active = this.active;
            Reference2IntMap<TutorialConfig> visible = this.visible;
            ResourceKey dimension = camera.f_19853_.m_46472_();
            BlockPos pos = camera.m_142538_();
            if (!pos.equals((Object)this.lastPlayerPos)) {
                this.lastPlayerPos = pos;
                active.clear();
                for (TutorialConfig tutorial : this.clientState.getTutorialsAt((ResourceKey<Level>)dimension, pos)) {
                    active.add(tutorial);
                    visible.putIfAbsent((Object)tutorial, 0);
                }
            }
            this.tickVisibleTutorials(camera, visible);
        }

        private void tickVisibleTutorials(Entity camera, Reference2IntMap<TutorialConfig> visible) {
            ObjectIterator iterator = Reference2IntMaps.fastIterator(visible);
            while (iterator.hasNext()) {
                Reference2IntMap.Entry entry = (Reference2IntMap.Entry)iterator.next();
                TutorialConfig tutorial = (TutorialConfig)entry.getKey();
                int ticks = this.tickTutorial(camera, entry.getIntValue(), tutorial);
                entry.setValue(ticks);
                if (ticks > 0) continue;
                iterator.remove();
            }
        }

        private int tickTutorial(Entity camera, int ticks, TutorialConfig tutorial) {
            List<TutorialWidget> widgets = tutorial.getWidgets();
            for (TutorialWidget widget : widgets) {
                TutorialRenderManager.tickWidget(widget, camera);
            }
            if (this.active.contains(tutorial)) {
                return ticks < 10 ? ticks + 1 : ticks;
            }
            return ticks - 1;
        }
    }
}

