/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.ImageDisplayWidget;

public final class ImageDisplayRenderer
implements TutorialWidgetRenderer<ImageDisplayWidget> {
    @Override
    public void render(ImageDisplayWidget widget, LevelRenderer context, PoseStack matrixStack, Camera camera, float partialTicks, float animation) {
        Vec3 view = camera.m_90583_();
        Vec3 pos = widget.getPos();
        ImageDisplayWidget.Texture texture = widget.getTexture();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(matrixStack.m_85850_().m_85861_());
        modelViewStack.m_85837_(pos.f_82479_ - view.f_82479_, pos.f_82480_ - view.f_82480_, pos.f_82481_ - view.f_82481_);
        if (pointAlong != null) {
            modelViewStack.m_166854_(pointAlong);
        } else {
            modelViewStack.m_85845_(camera.m_90591_());
        }
        modelViewStack.m_85841_(-scale, -scale, scale);
        RenderSystem.m_157182_();
        RenderSystem.m_69464_();
        RenderSystem.m_69482_();
        RenderSystem.m_69493_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float alpha = Easings.inOutSine(animation);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110500_((ResourceLocation)texture.getPath()));
        float textureWidth = texture.getWidth();
        float textureHeight = texture.getHeight();
        float minSize = Math.min(textureWidth, textureHeight);
        float width = 0.5f * textureWidth / minSize;
        float height = 0.5f * textureHeight / minSize;
        builder.m_5483_((double)(-width), (double)(-height), 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texture.getMinU(), texture.getMinV()).m_7120_(240, 240).m_5752_();
        builder.m_5483_((double)width, (double)(-height), 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texture.getMaxU(), texture.getMinV()).m_7120_(240, 240).m_5752_();
        builder.m_5483_((double)width, (double)height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texture.getMaxU(), texture.getMaxV()).m_7120_(240, 240).m_5752_();
        builder.m_5483_((double)(-width), (double)height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texture.getMinU(), texture.getMaxV()).m_7120_(240, 240).m_5752_();
        buffer.m_109911_();
        RenderSystem.m_69481_();
        RenderSystem.m_69465_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

