/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.lovetropics.tutorials.client.widget.TutorialWidgetRenderer;
import org.lovetropics.tutorials.util.Easings;
import org.lovetropics.tutorials.widget.TextDisplayWidget;

public final class TextDisplayRenderer
implements TutorialWidgetRenderer<TextDisplayWidget> {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    @Override
    public void render(TextDisplayWidget widget, LevelRenderer context, PoseStack matrixStack, Camera camera, float partialTicks, float animation) {
        Vec3 view = camera.m_90583_();
        Vec3 pos = widget.getPos();
        Component text = widget.getText();
        float scale = widget.getScale();
        Matrix4f pointAlong = widget.getPointAlongMatrix();
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(matrixStack.m_85850_().m_85861_());
        modelViewStack.m_85837_(pos.f_82479_ - view.f_82479_, pos.f_82480_ - view.f_82480_, pos.f_82481_ - view.f_82481_);
        if (pointAlong != null) {
            modelViewStack.m_166854_(pointAlong);
        } else {
            modelViewStack.m_85845_(camera.m_90591_());
        }
        modelViewStack.m_85841_(-scale, -scale, scale);
        RenderSystem.m_157182_();
        RenderSystem.m_69464_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float alpha = Easings.inOutSine(animation);
        if (alpha >= 0.1f) {
            Font font = TextDisplayRenderer.CLIENT.f_91062_;
            Matrix4f identity = Transformation.m_121093_().m_121104_();
            int textColor = TextDisplayRenderer.alphaToColor(alpha) | 0xFFFFFF;
            int backgroundColor = TextDisplayRenderer.alphaToColor(TextDisplayRenderer.CLIENT.f_91066_.m_92141_(0.25f) * alpha);
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            List lines = font.m_92923_((FormattedText)text, widget.getWrapLength());
            int n = lines.size();
            Objects.requireNonNull(font);
            float lineY = (float)(-(n * 9)) / 2.0f;
            for (FormattedCharSequence line : lines) {
                font.m_92733_(line, (float)(-font.m_92724_(line)) / 2.0f, lineY, textColor, false, identity, (MultiBufferSource)buffer, false, backgroundColor, 0xF000F0);
                Objects.requireNonNull(font);
                lineY += 9.0f;
            }
            buffer.m_109911_();
        }
        RenderSystem.m_69481_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static int alphaToColor(float alpha) {
        return Mth.m_14143_((float)(alpha * 255.0f)) << 24;
    }
}

