/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.network;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.lovetropics.tutorials.TutorialConfig;
import org.lovetropics.tutorials.client.TutorialClientState;

public class SendTutorialsMessage {
    private final List<TutorialConfig> tutorials;

    public SendTutorialsMessage(List<TutorialConfig> tutorials) {
        this.tutorials = tutorials;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.tutorials.size());
        for (TutorialConfig tutorial : this.tutorials) {
            TutorialConfig.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)tutorial).result().ifPresent(nbt -> buffer.m_130079_((CompoundTag)nbt));
        }
    }

    public static SendTutorialsMessage decode(FriendlyByteBuf buffer) {
        int count = buffer.m_130242_();
        ArrayList<TutorialConfig> tutorials = new ArrayList<TutorialConfig>(count);
        for (int i = 0; i < count; ++i) {
            TutorialConfig.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)buffer.m_130260_()).result().ifPresent(tutorials::add);
        }
        return new SendTutorialsMessage(tutorials);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> TutorialClientState.set(this.tutorials));
        ctx.get().setPacketHandled(true);
    }
}

