/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget;

import com.lovetropics.tutorials.repack.ltlib.codec.MoreCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.lovetropics.tutorials.widget.DisplayPlane;
import org.lovetropics.tutorials.widget.TutorialWidget;
import org.lovetropics.tutorials.widget.TutorialWidgetType;

public final class TextDisplayWidget
implements TutorialWidget {
    public static final Codec<TextDisplayWidget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MoreCodecs.VECTOR_3D.fieldOf("pos").forGetter(c -> c.pos), (App)MoreCodecs.TEXT.fieldOf("text").forGetter(c -> c.text), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(0.0625f)).forGetter(c -> Float.valueOf(c.scale)), (App)Codec.INT.optionalFieldOf("wrap_length", (Object)1000).forGetter(c -> c.wrapLength), (App)MoreCodecs.VECTOR_3F.optionalFieldOf("point_along").forGetter(c -> Optional.ofNullable(c.pointAlong))).apply((Applicative)instance, TextDisplayWidget::new));
    public static final TutorialWidgetType<TextDisplayWidget> TYPE = TutorialWidgetType.register("text", CODEC);
    private final Vec3 pos;
    private final Component text;
    private final float scale;
    private final int wrapLength;
    private final Vector3f pointAlong;
    private final DisplayPlane plane;

    private TextDisplayWidget(Vec3 pos, Component text, float scale, int wrapLength, Optional<Vector3f> pointAlong) {
        this.pos = pos;
        this.text = text;
        this.scale = scale;
        this.wrapLength = wrapLength;
        this.pointAlong = pointAlong.orElse(null);
        this.plane = pointAlong.map(DisplayPlane::new).orElse(null);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public Component getText() {
        return this.text;
    }

    public float getScale() {
        return this.scale;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    @Nullable
    public Matrix4f getPointAlongMatrix() {
        DisplayPlane plane = this.plane;
        return plane != null ? plane.getPointAlongMatrix() : null;
    }

    @Override
    public TutorialWidgetType<?> getType() {
        return TYPE;
    }
}

