/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget.focus;

import com.lovetropics.tutorials.repack.ltlib.BlockBox;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class WidgetFocus {
    public static final Codec<WidgetFocus> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockBox.CODEC.fieldOf("looking_at").forGetter(c -> c.lookingAt), (App)Codec.FLOAT.optionalFieldOf("distance", (Object)Float.valueOf(10.0f)).forGetter(c -> Float.valueOf(c.distance))).apply((Applicative)instance, WidgetFocus::new));
    private final BlockBox lookingAt;
    private final AABB lookingAtAabb;
    private final float distance;

    public WidgetFocus(BlockBox lookingAt, float distance) {
        this.lookingAt = lookingAt;
        this.lookingAtAabb = lookingAt.asAabb();
        this.distance = distance;
    }

    public boolean test(Entity camera) {
        Vec3 eyes = camera.m_20299_(1.0f);
        Vec3 view = camera.m_20252_(1.0f);
        Vec3 lookingAt = eyes.m_82549_(view.m_82490_((double)this.distance));
        return this.lookingAtAabb.m_82371_(eyes, lookingAt).isPresent();
    }
}

