/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.entity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.tterrag.dummyplayers.DummyPlayers;
import com.tterrag.dummyplayers.entity.UpdateDummyTexturesMessage;
import com.tterrag.dummyplayers.item.DummyPlayerItem;
import com.tterrag.dummyplayers.network.LTExtrasNetwork;
import com.tterrag.dummyplayers.repack.registrate.Registrate;
import com.tterrag.dummyplayers.repack.registrate.util.entry.ItemEntry;
import com.tterrag.dummyplayers.repack.registrate.util.entry.RegistryEntry;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public class DummyPlayerEntity
extends ArmorStand {
    public static final RegistryEntry<EntityType<DummyPlayerEntity>> DUMMY_PLAYER = ((Registrate)DummyPlayers.registrate().object("dummy_player")).entity(DummyPlayerEntity::new, MobCategory.MISC).properties(b -> b.m_20699_(0.6f, 1.8f)).register();
    public static final ItemEntry<DummyPlayerItem> SPAWNER = DummyPlayers.registrate().item(DummyPlayerItem::new).register();
    private static final EntityDataSerializer<GameProfile> PROFILE_SERIALIZER = new EntityDataSerializer<GameProfile>(){

        public GameProfile copy(GameProfile value) {
            return value == null ? null : new GameProfile(value.getId(), value.getName());
        }

        public GameProfile read(FriendlyByteBuf buf) {
            byte mode = buf.readByte();
            UUID id = null;
            String name = null;
            if ((mode & 1) > 0) {
                id = buf.m_130259_();
            }
            if ((mode & 2) > 0) {
                name = buf.m_130136_(100);
            }
            if (id == null && name == null) {
                return null;
            }
            return new GameProfile(id, name);
        }

        public void write(FriendlyByteBuf buf, GameProfile value) {
            int mode = 0;
            if (value != null && value.getId() != null) {
                mode |= 1;
            }
            if (value != null && value.getName() != null) {
                mode |= 2;
            }
            buf.writeByte(mode);
            if ((mode & 1) > 0) {
                buf.m_130077_(value.getId());
            }
            if ((mode & 2) > 0) {
                buf.m_130072_(value.getName(), 100);
            }
        }
    };
    public static final GameProfile NULL_PROFILE;
    private static final EntityDataAccessor<GameProfile> GAME_PROFILE;
    private static final EntityDataAccessor<Optional<Component>> PREFIX;
    private static final EntityDataAccessor<Optional<Component>> SUFFIX;
    private static final NonNullLazy<GameProfileCache> PROFILE_CACHE;
    private boolean reloadTextures = true;
    private final SkinInfo skinInfo = new SkinInfo();

    public static void register() {
    }

    protected DummyPlayerEntity(EntityType<? extends DummyPlayerEntity> type, Level worldIn) {
        super(type, worldIn);
        if (!worldIn.f_46443_) {
            this.f_19804_.m_135381_(f_31524_, (Object)4);
        }
    }

    public DummyPlayerEntity(Level worldIn, double posX, double posY, double posZ) {
        this(DUMMY_PLAYER.get(), worldIn);
        this.m_6034_(posX, posY, posZ);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GAME_PROFILE, (Object)NULL_PROFILE);
        this.f_19804_.m_135372_(PREFIX, Optional.empty());
        this.f_19804_.m_135372_(SUFFIX, Optional.empty());
    }

    public Component m_5677_() {
        return this.getProfile().getName() == null ? super.m_5677_() : Component.m_237113_((String)this.getProfile().getName());
    }

    public Component m_5446_() {
        MutableComponent ret = super.m_5446_().m_6881_();
        Component prefix = ((Optional)this.f_19804_.m_135370_(PREFIX)).orElse(null);
        Component suffix = ((Optional)this.f_19804_.m_135370_(SUFFIX)).orElse(null);
        if (prefix != null) {
            ret = prefix.m_6881_().m_7220_((Component)ret);
        }
        if (suffix != null) {
            ret = ret.m_7220_((Component)suffix.m_6881_());
        }
        return ret;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SPAWNER.get());
    }

    public GameProfile getProfile() {
        return (GameProfile)this.f_19804_.m_135370_(GAME_PROFILE);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((Optional)this.f_19804_.m_135370_(PREFIX)).ifPresent(prefix -> compound.m_128359_("NamePrefix", Component.Serializer.m_130703_((Component)prefix)));
        ((Optional)this.f_19804_.m_135370_(SUFFIX)).ifPresent(suffix -> compound.m_128359_("NameSuffix", Component.Serializer.m_130703_((Component)suffix)));
        GameProfile profile = this.getProfile();
        if (profile.equals((Object)NULL_PROFILE)) {
            return;
        }
        if (profile.getId() != null) {
            compound.m_128362_("ProfileID", profile.getId());
        } else if (profile.getName() != null) {
            compound.m_128359_("ProfileName", profile.getName());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("NamePrefix", 8)) {
            this.f_19804_.m_135381_(PREFIX, Optional.ofNullable(Component.Serializer.m_130701_((String)compound.m_128461_("NamePrefix"))));
        }
        if (compound.m_128425_("NameSuffix", 8)) {
            this.f_19804_.m_135381_(SUFFIX, Optional.ofNullable(Component.Serializer.m_130701_((String)compound.m_128461_("NameSuffix"))));
        }
        if (compound.m_128425_("ProfileName", 8)) {
            String oldName;
            String newName = compound.m_128461_("ProfileName");
            if (!Objects.equals(newName, oldName = this.getProfile().getName())) {
                this.f_19804_.m_135381_(GAME_PROFILE, (Object)(StringUtils.isBlank((CharSequence)newName) ? NULL_PROFILE : new GameProfile(null, newName)));
                this.fillProfile();
            }
        } else if (compound.m_128403_("ProfileID")) {
            UUID oldId = this.getProfile().getId();
            UUID newId = compound.m_128342_("ProfileID");
            if (!Objects.equals(newId, oldId)) {
                this.f_19804_.m_135381_(GAME_PROFILE, (Object)new GameProfile(newId, null));
                this.fillProfile();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.reloadTextures) {
            LTExtrasNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDummyTexturesMessage(this.m_19879_()));
            this.reloadTextures = false;
        }
    }

    void fillProfile() {
        GameProfile profile = this.getProfile();
        if (!profile.equals((Object)NULL_PROFILE)) {
            this.reloadTextures();
        }
        CompletableFuture.supplyAsync(() -> {
            Optional ret;
            GameProfileCache cache;
            if (profile.getId() != null) {
                Optional ret2 = ((GameProfileCache)PROFILE_CACHE.get()).m_11002_(profile.getId());
                if (ret2.isPresent()) {
                    return (GameProfile)ret2.get();
                }
                if (SkullBlockEntity.f_59756_ == null) {
                    return profile;
                }
                try {
                    return SkullBlockEntity.f_59756_.fillProfileProperties(profile, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return profile;
                }
            }
            GameProfileCache gameProfileCache = cache = (GameProfileCache)PROFILE_CACHE.get();
            synchronized (gameProfileCache) {
                ret = cache.m_10996_(this.getProfile().getName());
            }
            return ret.orElse(profile);
        }).thenAcceptAsync(gp -> {
            this.f_19804_.m_135381_(GAME_PROFILE, gp);
            this.reloadTextures();
        }, this.getMainThreadExecutor());
    }

    private Executor getMainThreadExecutor() {
        return this.m_20193_().f_46443_ ? (Executor)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> Minecraft::m_91087_) : this.m_20194_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    protected void updateSkinTexture() {
        if (this.reloadTextures) {
            DummyPlayerEntity dummyPlayerEntity = this;
            synchronized (dummyPlayerEntity) {
                if (this.reloadTextures) {
                    this.skinInfo.playerTextures.clear();
                    this.reloadTextures = false;
                    if (this.getProfile().equals((Object)NULL_PROFILE) || this.getProfile().getId() == null) {
                        return;
                    }
                    LogManager.getLogger().info("Loading skin data for GameProfile: " + this.getProfile());
                    SkinInfo skinInfo = this.skinInfo;
                    Minecraft.m_91087_().m_91109_().m_118817_(this.getProfile(), (p_210250_1_, p_210250_2_, p_210250_3_) -> {
                        SkinInfo skinInfo2 = skinInfo;
                        synchronized (skinInfo2) {
                            skinInfo.playerTextures.put(p_210250_1_, p_210250_2_);
                            if (p_210250_1_ == MinecraftProfileTexture.Type.SKIN) {
                                skinInfo.skinType = p_210250_3_.getMetadata("model");
                                if (skinInfo.skinType == null) {
                                    skinInfo.skinType = "default";
                                }
                            }
                        }
                    }, true);
                }
            }
        }
    }

    private UUID getSkinUUID() {
        return this.getProfile().equals((Object)NULL_PROFILE) || this.getProfile().getId() == null ? this.m_20148_() : this.getProfile().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLocation getSkin() {
        this.updateSkinTexture();
        SkinInfo skinInfo = this.skinInfo;
        synchronized (skinInfo) {
            return this.skinInfo.playerTextures.computeIfAbsent(MinecraftProfileTexture.Type.SKIN, $ -> DefaultPlayerSkin.m_118627_((UUID)this.getSkinUUID()));
        }
    }

    public ResourceLocation getCape() {
        return this.skinInfo.playerTextures.get(MinecraftProfileTexture.Type.CAPE);
    }

    public ResourceLocation getElytra() {
        return this.skinInfo.playerTextures.getOrDefault(MinecraftProfileTexture.Type.ELYTRA, this.getCape());
    }

    public String getSkinType() {
        return this.skinInfo.skinType == null ? DefaultPlayerSkin.m_118629_((UUID)this.getSkinUUID()) : this.skinInfo.skinType;
    }

    void reloadTextures() {
        this.reloadTextures = true;
    }

    static {
        EntityDataSerializers.m_135050_(PROFILE_SERIALIZER);
        NULL_PROFILE = new GameProfile(UUID.fromString("e664daf0-5962-45a5-b8df-e4c992d372a9"), null);
        GAME_PROFILE = SynchedEntityData.m_135353_(DummyPlayerEntity.class, PROFILE_SERIALIZER);
        PREFIX = SynchedEntityData.m_135353_(DummyPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
        SUFFIX = SynchedEntityData.m_135353_(DummyPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
        PROFILE_CACHE = NonNullLazy.of(() -> new GameProfileCache(ServerLifecycleHooks.getCurrentServer().m_129926_(), new File(".", "dummyplayercache.json")));
    }

    private static class SkinInfo {
        private final Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures = Maps.newEnumMap(MinecraftProfileTexture.Type.class);
        @Nullable
        private String skinType;

        private SkinInfo() {
        }
    }
}

