/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.repack.registrate.providers;

import com.tterrag.dummyplayers.repack.registrate.AbstractRegistrate;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateAdvancementProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateDataProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateGenericProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateLangProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.RegistrateTagsProvider;
import com.tterrag.dummyplayers.repack.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.FieldsAreNonnullByDefault;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullFunction;
import com.tterrag.dummyplayers.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.LogicalSide;

@FunctionalInterface
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public interface ProviderType<T extends RegistrateProvider> {
    public static final ProviderType<RegistrateRecipeProvider> RECIPE = ProviderType.register("recipe", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateRecipeProvider((AbstractRegistrate<?>)p, e.getGenerator().getPackOutput()));
    public static final ProviderType<RegistrateAdvancementProvider> ADVANCEMENT = ProviderType.register("advancement", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateAdvancementProvider((AbstractRegistrate<?>)p, e.getGenerator().getPackOutput(), e.getLookupProvider()));
    public static final ProviderType<RegistrateLootTableProvider> LOOT = ProviderType.register("loot", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateLootTableProvider((AbstractRegistrate<?>)p, e.getGenerator().getPackOutput()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<Block>> BLOCK_TAGS = ProviderType.register("tags/block", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<Block>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<Block>>)type, "blocks", e.getGenerator().getPackOutput(), (ResourceKey<Registry<Block>>)Registries.f_256747_, e.getLookupProvider(), block -> block.m_204297_().m_205785_(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateItemTagsProvider> ITEM_TAGS = ProviderType.registerDelegate("tags/item", type -> (p, e, existing) -> new RegistrateItemTagsProvider(p, (ProviderType<RegistrateItemTagsProvider>)type, "items", e.getGenerator().getPackOutput(), e.getLookupProvider(), ((TagsProvider)existing.get(BLOCK_TAGS)).m_274426_(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<Fluid>> FLUID_TAGS = ProviderType.register("tags/fluid", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<Fluid>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<Fluid>>)type, "fluids", e.getGenerator().getPackOutput(), (ResourceKey<Registry<Fluid>>)Registries.f_256808_, e.getLookupProvider(), fluid -> fluid.m_205069_().m_205785_(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<EntityType<?>>> ENTITY_TAGS = ProviderType.register("tags/entity", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<EntityType>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<EntityType>>)type, "entity_types", e.getGenerator().getPackOutput(), (ResourceKey<Registry<EntityType>>)Registries.f_256939_, e.getLookupProvider(), entityType -> entityType.m_204041_().m_205785_(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateGenericProvider> GENERIC_SERVER = ProviderType.register("registrate_generic_server_provider", (ProviderType<T> providerType) -> (registrate, event) -> new RegistrateGenericProvider((AbstractRegistrate<?>)registrate, (GatherDataEvent)event, LogicalSide.SERVER, (ProviderType<RegistrateGenericProvider>)providerType));
    public static final ProviderType<RegistrateBlockstateProvider> BLOCKSTATE = ProviderType.register("blockstate", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateBlockstateProvider((AbstractRegistrate<?>)p, e.getGenerator().getPackOutput(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateItemModelProvider> ITEM_MODEL = ProviderType.register("item_model", (AbstractRegistrate<?> p, GatherDataEvent e, Map<ProviderType<?>, RegistrateProvider> existing) -> new RegistrateItemModelProvider(p, e.getGenerator().getPackOutput(), ((RegistrateBlockstateProvider)existing.get(BLOCKSTATE)).getExistingFileHelper()));
    public static final ProviderType<RegistrateLangProvider> LANG = ProviderType.register("lang", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateLangProvider((AbstractRegistrate<?>)p, e.getGenerator().getPackOutput()));
    public static final ProviderType<RegistrateGenericProvider> GENERIC_CLIENT = ProviderType.register("registrate_generic_client_provider", (ProviderType<T> providerTYpe) -> (registrate, event) -> new RegistrateGenericProvider((AbstractRegistrate<?>)registrate, (GatherDataEvent)event, LogicalSide.CLIENT, (ProviderType<RegistrateGenericProvider>)providerTYpe));

    public T create(AbstractRegistrate<?> var1, GatherDataEvent var2, Map<ProviderType<?>, RegistrateProvider> var3);

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> registerDelegate(String name, final NonNullUnaryOperator<ProviderType<T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@Nonnull AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return ((ProviderType)type.apply(this)).create(parent, event, existing);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullFunction<ProviderType<T>, NonNullBiFunction<AbstractRegistrate<?>, GatherDataEvent, T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@Nonnull AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)((NonNullBiFunction)type.apply(this)).apply(parent, event);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullBiFunction<AbstractRegistrate<?>, GatherDataEvent, T> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)type.apply(parent, event);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, ProviderType<T> type) {
        RegistrateDataProvider.TYPES.put((Object)name, type);
        return type;
    }
}

