/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.BlockFactory;
import com.lovetropics.extras.ExtraTags;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.NamedSupplier;
import com.lovetropics.extras.block.BoringEndRodBlock;
import com.lovetropics.extras.block.CheckpointBlock;
import com.lovetropics.extras.block.CurtainBlock;
import com.lovetropics.extras.block.CustomSeagrassBlock;
import com.lovetropics.extras.block.CustomSugarCaneBlock;
import com.lovetropics.extras.block.CustomTallSeagrassBlock;
import com.lovetropics.extras.block.FakeWaterBlock;
import com.lovetropics.extras.block.GirderBlock;
import com.lovetropics.extras.block.GlowSticksBlock;
import com.lovetropics.extras.block.LightweightBarrierBlock;
import com.lovetropics.extras.block.MobControllerBlock;
import com.lovetropics.extras.block.PanelBlock;
import com.lovetropics.extras.block.ParticleEmitterBlock;
import com.lovetropics.extras.block.PassableBarrierBlock;
import com.lovetropics.extras.block.PianguasBlock;
import com.lovetropics.extras.block.ReedsBlock;
import com.lovetropics.extras.block.RopeBlock;
import com.lovetropics.extras.block.ScientificNameBlock;
import com.lovetropics.extras.block.SpeedyBlock;
import com.lovetropics.extras.block.SubmergedLilyBlock;
import com.lovetropics.extras.block.ThornStemBlock;
import com.lovetropics.extras.block.WaterBarrierBlock;
import com.lovetropics.extras.block.entity.MobControllerBlockEntity;
import com.lovetropics.extras.block.entity.ParticleEmitterBlockEntity;
import com.lovetropics.extras.data.ImposterBlockTemplate;
import com.lovetropics.extras.data.ModelGenUtil;
import com.lovetropics.extras.mixin.BlockPropertiesMixin;
import com.lovetropics.lib.block.CustomShapeBlock;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.ScaffoldingBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralFanBlock;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ExtraBlocks {
    public static final Registrate REGISTRATE = LTExtras.registrate();
    public static final BlockEntry<WaterBarrierBlock> WATER_BARRIER = ((BlockBuilder)REGISTRATE.block("water_barrier", WaterBarrierBlock::new).initialProperties(() -> Blocks.f_50375_).properties(p -> p.m_222994_()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", new ResourceLocation("item/barrier")))).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{new ResourceLocation("block/water_still"), new ResourceLocation("item/barrier")})).build()).register();
    public static final BlockEntry<LightweightBarrierBlock> LIGHTWEIGHT_BARRIER = ((BlockBuilder)REGISTRATE.block("lightweight_barrier", LightweightBarrierBlock::new).initialProperties(() -> Blocks.f_50375_).properties(p -> p.m_60913_(0.0f, 3600000.0f).m_222994_()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", new ResourceLocation("item/barrier")))).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{new ResourceLocation("item/barrier")})).build()).register();
    public static final BlockEntry<PassableBarrierBlock> PASSABLE_BARRIER = ((BlockBuilder)REGISTRATE.block("passable_barrier", PassableBarrierBlock::new).initialProperties(() -> Blocks.f_50375_).properties(p -> p.m_222994_()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", new ResourceLocation("item/barrier")))).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{new ResourceLocation("item/barrier")})).build()).register();
    public static final BlockEntry<FakeWaterBlock> FAKE_WATER = ((BlockBuilder)REGISTRATE.block("fake_water", FakeWaterBlock::new).initialProperties(() -> Blocks.f_50375_).properties(p -> p.m_222994_()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", new ResourceLocation("block/water_still")))).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{new ResourceLocation("block/water_still")})).build()).register();
    public static final BlockEntry<CustomShapeBlock> BUOY = ((BlockBuilder)REGISTRATE.block("buoy", p -> new CustomShapeBlock(Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)), p)).initialProperties(() -> Blocks.f_50273_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), new ResourceLocation("block/block"))).ao(false)).texture("beacon", new ResourceLocation("block/beacon"))).texture("base", new ResourceLocation("block/dark_prismarine"))).texture("particle", new ResourceLocation("block/dark_prismarine"))).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 3.0f, 14.0f).textureAll("#base").face(Direction.DOWN).cullface(Direction.DOWN).end().end()).element().from(3.0f, 3.0f, 3.0f).to(13.0f, 14.0f, 13.0f).textureAll("#beacon").end())).item(PlaceOnWaterBlockItem::new).build()).register();
    public static final BlockEntry<PanelBlock> GLASS_PANEL = ((BlockBuilder)REGISTRATE.block("glass_panel", PanelBlock::new).initialProperties(() -> Blocks.f_50058_).blockstate((ctx, prov) -> prov.directionalBlock((Block)ctx.get(), (ModelFile)prov.models().trapdoorTop(ctx.getName(), prov.blockTexture(Blocks.f_50058_)))).loot(RegistrateBlockLootTables::m_245644_).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.trapdoorBottom(ctx.getName(), prov.mcLoc("block/glass"))).build()).register();
    public static final BlockEntry<GirderBlock> STEEL_GIRDER = ExtraBlocks.steelGirder("");
    public static final BlockEntry<GirderBlock> RUSTING_STEEL_GIRDER = ExtraBlocks.steelGirder("rusting");
    public static final BlockEntry<GirderBlock> RUSTED_STEEL_GIRDER = ExtraBlocks.steelGirder("rusted");
    public static final BlockEntry<CheckpointBlock> CHECKPOINT = ((BlockBuilder)REGISTRATE.block("checkpoint", CheckpointBlock::new).initialProperties(() -> Blocks.f_50375_).properties(p -> p.m_222994_()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", prov.mcLoc("item/structure_void")))).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{new ResourceLocation("item/structure_void")})).build()).register();
    public static final BlockEntry<ScaffoldingBlock> METAL_SCAFFOLDING = ((BlockBuilder)REGISTRATE.block("metal_scaffolding", p -> new ScaffoldingBlock((BlockBehaviour.Properties)p){

        public boolean isScaffolding(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
            return true;
        }
    }).initialProperties(() -> Blocks.f_50616_).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).partialState().with((Property)ScaffoldingBlock.f_56014_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{ModelGenUtil.scaffoldingModel((DataGenContext<Block, ScaffoldingBlock>)ctx, prov, "unstable")}).partialState().with((Property)ScaffoldingBlock.f_56014_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{ModelGenUtil.scaffoldingModel((DataGenContext<Block, ScaffoldingBlock>)ctx, prov, "stable")})).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13082_}).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}).item(ScaffoldingBlockItem::new).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.modLoc("block/metal_scaffolding_stable"))).build()).register();
    public static final BlockEntry<IronBarsBlock> RUSTY_IRON_BARS = ((BlockBuilder)REGISTRATE.block("rusty_iron_bars", p -> new IronBarsBlock((BlockBehaviour.Properties)p){}).initialProperties(() -> Blocks.f_50183_).blockstate((ctx, prov) -> ModelGenUtil.barsBlock((DataGenContext<Block, IronBarsBlock>)ctx, prov)).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx)).build()).register();
    public static final BlockEntry<LadderBlock> METAL_LADDER = ExtraBlocks.ladder("metal_ladder", "metal_ladder").register();
    public static final BlockEntry<LadderBlock> RUSTY_METAL_LADDER = ExtraBlocks.ladder("rusty_metal_ladder", "rusty_metal_ladder").register();
    public static final BlockEntry<LadderBlock> FAST_METAL_LADDER = ExtraBlocks.ladder("fast_metal_ladder", "metal_ladder").tag(new TagKey[]{ExtraTags.Blocks.CLIMBABLE_FAST}).register();
    public static final BlockEntry<LadderBlock> FAST_RUSTY_METAL_LADDER = ExtraBlocks.ladder("fast_rusty_metal_ladder", "rusty_metal_ladder").tag(new TagKey[]{ExtraTags.Blocks.CLIMBABLE_FAST}).register();
    public static final BlockEntry<Block> RUSTY_PAINTED_METAL = REGISTRATE.block("rusty_painted_metal", Block::new).initialProperties(() -> Blocks.f_50075_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}).simpleItem().register();
    public static final BlockEntry<MobControllerBlock> MOB_CONTROLLER = ((BlockBuilder)REGISTRATE.block("mob_controller", MobControllerBlock::new).initialProperties(() -> Blocks.f_50075_).simpleItem().blockEntity(MobControllerBlockEntity::new).build()).register();
    public static final BlockEntityEntry<MobControllerBlockEntity> MOB_CONTROLLER_BE = BlockEntityEntry.cast((RegistryEntry)MOB_CONTROLLER.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
    public static final BlockEntry<ParticleEmitterBlock> PARTICLE_EMITTER = ((BlockBuilder)REGISTRATE.block("particle_emitter", ParticleEmitterBlock::new).initialProperties(() -> Blocks.f_50075_).simpleItem().blockEntity(ParticleEmitterBlockEntity::new).build()).register();
    public static final BlockEntityEntry<ParticleEmitterBlockEntity> PARTICLE_EMITTER_BE = BlockEntityEntry.cast((RegistryEntry)PARTICLE_EMITTER.getSibling(ForgeRegistries.BLOCK_ENTITY_TYPES));
    public static final BlockEntry<Block> BLACK_CONCRETE_POWDER_FAKE = ((BlockBuilder)REGISTRATE.block("black_concrete_powder_fake", Block::new).initialProperties(() -> Blocks.f_50493_).item().model((ctx, prov) -> prov.withExistingParent(ctx.getName(), new ResourceLocation("block/black_concrete_powder"))).build()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allYRotations((ModelFile)prov.models().getExistingFile(new ResourceLocation("block/black_concrete_powder")), (int)0, (boolean)false))).register();
    public static final BlockEntry<StainedGlassBlock> SMOOTH_LIGHT_GRAY_STAINED_GLASS = REGISTRATE.block("smooth_light_gray_stained_glass", p -> new StainedGlassBlock(DyeColor.LIGHT_GRAY, p)).initialProperties(() -> Blocks.f_50208_).loot(RegistrateBlockLootTables::m_245644_).addLayer(() -> RenderType::m_110466_).simpleItem().register();
    public static final BlockEntry<ReedsBlock> REEDS = ((BlockBuilder)REGISTRATE.block("reeds", ReedsBlock::new).initialProperties(() -> Blocks.f_50130_).properties(p -> p.m_222994_()).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
        ReedsBlock.Type type = (ReedsBlock.Type)((Object)((Object)((Object)state.m_61143_(ReedsBlock.TYPE))));
        ConfiguredModel.Builder builder = ConfiguredModel.builder();
        String[] textures = type.getTextures();
        for (int i = 0; i < textures.length; ++i) {
            String texture = textures[i];
            ResourceLocation textureLoc = prov.modLoc("block/" + texture);
            builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(texture, "block/crop")).texture("crop", textureLoc)).texture("particle", textureLoc));
            if (i >= textures.length - 1) continue;
            builder = builder.nextModel();
        }
        return builder.build();
    })).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("block/reeds_top_tall")})).build()).register();
    public static final BlockEntry<CustomSugarCaneBlock> SUGAR_CANE = ((BlockBuilder)REGISTRATE.block("sugar_cane", CustomSugarCaneBlock::new).initialProperties(() -> Blocks.f_50130_).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
        CustomSugarCaneBlock.Type type = (CustomSugarCaneBlock.Type)((Object)((Object)((Object)state.m_61143_(CustomSugarCaneBlock.TYPE))));
        String modelName = ctx.getName() + "_" + type.m_7912_();
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, "block/crop")).texture("crop", prov.modLoc("block/" + modelName))).texture("particle", "#crop")).build();
    })).addLayer(() -> RenderType::m_110463_).defaultLoot().item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("block/sugar_cane_top")})).build()).register();
    public static final BlockEntry<PianguasBlock> PIANGUAS = ((BlockBuilder)REGISTRATE.block("pianguas", PianguasBlock::new).properties(p -> p.m_284180_(MapColor.f_283947_).m_60910_().m_60966_().m_280658_(NoteBlockInstrument.BASEDRUM)).blockstate((ctx, prov) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("pianguas")).ao(false)).texture("base", "block/pianguas")).texture("particle", "block/pianguas")).element().from(0.0f, 0.0f, 0.1f).to(16.0f, 16.0f, 0.1f).face(Direction.SOUTH).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#base").end().end();
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
        PianguasBlock.ATTACHMENTS.forEach((direction, property) -> {
            if (direction.m_122434_().m_122479_()) {
                int rotationY = ((int)direction.m_122435_() + 180) % 360;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(rotationY).uvLock(true).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true});
            } else {
                int rotationX = direction == Direction.DOWN ? 90 : 270;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(rotationX).uvLock(true).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true});
            }
        });
    }).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("block/pianguas")})).build()).register();
    public static final BlockEntry<RopeBlock> OLD_ROPE = ExtraBlocks.rope("old_rope").register();
    public static final BlockEntry<RopeBlock> PARACORD = ExtraBlocks.rope("paracord").tag(new TagKey[]{ExtraTags.Blocks.CLIMBABLE_VERY_FAST}).register();
    private static final List<DyeColor> GLOW_STICKS_DYES = Arrays.stream(DyeColor.values()).filter(color -> color != DyeColor.BLACK && color != DyeColor.LIGHT_GRAY && color != DyeColor.GRAY).collect(Collectors.toList());
    public static final Map<DyeColor, BlockEntry<GlowSticksBlock>> GLOW_STICKS = GLOW_STICKS_DYES.stream().collect(Collectors.toMap(Function.identity(), dyeColor -> {
        String dyeName = dyeColor.m_7912_();
        String name = dyeName + "_glow_sticks";
        return REGISTRATE.block(name, GlowSticksBlock::new).properties(p -> p.m_60966_().m_60910_().m_60918_(SoundType.f_56744_).m_60955_().m_280658_(NoteBlockInstrument.HAT).m_60953_(value -> 6)).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/glow_sticks"))).texture("glow_sticks", prov.modLoc("block/glow_sticks/" + dyeName));
            prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
        }).addLayer(() -> RenderType::m_110466_).simpleItem().register();
    }));
    public static final BlockEntry<VineBlock> INFERTILE_VINE = ((BlockBuilder)REGISTRATE.block("infertile_vine", VineBlock::new).initialProperties(() -> Blocks.f_50191_).properties(p -> {
        ((BlockPropertiesMixin)p).setIsRandomlyTicking(false);
        return p;
    }).tag(new TagKey[]{BlockTags.f_13082_}).blockstate((ctx, prov) -> {}).addLayer(() -> RenderType::m_110463_).color(() -> () -> (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_()).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation("block/vine"), new ResourceLocation("item/barrier")})).color(() -> () -> ($, layer) -> layer == 0 ? FoliageColor.m_46113_() : -1).build()).register();
    public static final BlockEntry<DoorBlock> HEAVY_SPRUCE_DOOR = ((BlockBuilder)REGISTRATE.block("heavy_spruce_door", p -> new DoorBlock(p, BlockSetType.f_271132_)).initialProperties(() -> Blocks.f_50484_).blockstate((ctx, prov) -> {}).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_144280_}).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{new ResourceLocation("item/spruce_door")})).build()).register();
    public static final BlockEntry<ThornStemBlock> THORN_STEM = REGISTRATE.block("thorn_stem", ThornStemBlock::new).initialProperties(() -> Blocks.f_50054_).properties(p -> p.m_60955_().m_60924_((state, world, pos) -> false)).blockstate((ctx, prov) -> {
        ModelFile.ExistingModelFile core = prov.models().getExistingFile(prov.modLoc("block/thorn_stem"));
        ModelFile.ExistingModelFile connection = prov.models().getExistingFile(prov.modLoc("block/thorn_stem_connection"));
        MultiPartBlockStateBuilder multipart = ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)core).addModel()).end();
        PipeBlock.f_55154_.forEach((direction, value) -> {
            ConfiguredModel.Builder part = multipart.part().modelFile((ModelFile)connection).uvLock(true);
            if (direction.m_122434_().m_122479_()) {
                int angleY = (int)direction.m_122435_() % 360;
                part.rotationY(angleY);
                part.rotationX(90);
            } else {
                part.rotationX(direction == Direction.DOWN ? 0 : 180);
            }
            ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((Property)value, (Comparable[])new Boolean[]{true});
        });
    }).addLayer(() -> RenderType::m_110463_).simpleItem().register();
    public static final BlockEntry<BoringEndRodBlock> BORING_END_ROD = ((BlockBuilder)REGISTRATE.block("boring_end_rod", BoringEndRodBlock::new).initialProperties(() -> Blocks.f_50489_).defaultBlockstate().blockstate((ctx, prov) -> ModelGenUtil.rodBlock((DataGenContext<Block, BoringEndRodBlock>)ctx, prov)).item().model((ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.mcLoc("block/end_rod"))).build()).register();
    public static final BlockEntry<Block> LIME_BLOCK = REGISTRATE.block("lime_block", Block::new).initialProperties(() -> Blocks.f_50186_).properties(p -> p.m_60918_(SoundType.f_56750_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(ctx.getName(), prov.modLoc("block/lime_side"), prov.modLoc("block/lime_top")))).lang("Block of Lime").simpleItem().recipe((ctx, prov) -> {
        DataIngredient lime = DataIngredient.tag(ExtraTags.Items.LIME);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ctx.get())).m_126186_((Ingredient)lime, 9).m_126132_("has_lime", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(ExtraTags.Items.LIME)).m_176498_((Consumer)prov);
    }).defaultLoot().register();
    public static final BlockEntry<SlabBlock> SLICED_LIME = REGISTRATE.block("sliced_lime", SlabBlock::new).initialProperties(LIME_BLOCK).blockstate((ctx, prov) -> {
        ResourceLocation side = prov.modLoc("block/lime_side");
        ResourceLocation end = prov.modLoc("block/lime_top");
        ResourceLocation inside = prov.modLoc("block/lime_inside");
        prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)prov.models().slab(ctx.getName(), side, end, inside), (ModelFile)prov.models().slabTop(ctx.getName() + "_top", side, inside, end), (ModelFile)prov.models().getExistingFile(prov.modLoc("block/lime_block")));
    }).loot((loot, block) -> loot.m_247577_((Block)block, loot.m_247233_((Block)block))).simpleItem().recipe((ctx, prov) -> prov.slab(DataIngredient.items(LIME_BLOCK, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "lime_slab", true)).register();
    private static final VoxelShape PATH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final TemplateBuilder<SpeedyBlock, BlockFactory<SpeedyBlock>> SPEEDY_BLOCK_TEMPLATES = new TemplateBuilder().add(Blocks.f_50333_, SpeedyBlock::opaque).add(Blocks.f_50222_, SpeedyBlock::opaque).add(Blocks.f_50224_, SpeedyBlock::opaque).add(Blocks.f_50224_, SpeedyBlock::opaque).add(Blocks.f_50470_, SpeedyBlock::opaque).add(Blocks.f_49994_, SpeedyBlock::opaque).add(Blocks.f_152481_, p -> SpeedyBlock.transparent(PATH_SHAPE, p)).add(Blocks.f_50574_, SpeedyBlock::opaque).add(Blocks.f_50399_, SpeedyBlock::slab);
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends SpeedyBlock>> SPEEDY_BLOCKS = SPEEDY_BLOCK_TEMPLATES.build((object, factory) -> REGISTRATE.block("speedy_" + object.getId().m_135815_(), (NonNullFunction)factory).initialProperties(NonNullSupplier.of((Supplier)((Object)object))).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(object.getId()))).simpleItem().register());
    public static final BlockEntry<Block> DELIGHTED_OBSIDIAN = REGISTRATE.block("delighted_obsidian", Block::new).initialProperties(() -> Blocks.f_50723_).properties(p -> p.m_60953_(value -> 0)).tag(new TagKey[]{BlockTags.f_144282_, BlockTags.f_144284_}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().withExistingParent(ctx.getName(), "block/crying_obsidian"))).register();
    private static final TemplateBuilder<Block, ImposterBlockTemplate> IMPOSTER_BLOCK_TEMPLATES = new TemplateBuilder().add(Blocks.f_50585_, ImposterBlockTemplate.simpleCube()).add(Blocks.f_50586_, ImposterBlockTemplate.simpleCube()).add(Blocks.f_50588_, ImposterBlockTemplate.simpleCube()).add(Blocks.f_50584_, ImposterBlockTemplate.simpleCube()).add(Blocks.f_50595_, ImposterBlockTemplate.cross(BaseCoralPlantTypeBlock::new)).add(Blocks.f_50596_, ImposterBlockTemplate.cross(BaseCoralPlantTypeBlock::new)).add(Blocks.f_50598_, ImposterBlockTemplate.cross(BaseCoralPlantTypeBlock::new)).add(Blocks.f_50594_, ImposterBlockTemplate.cross(BaseCoralPlantTypeBlock::new));
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends Block>> IMPOSTER_BLOCKS = IMPOSTER_BLOCK_TEMPLATES.build((object, template) -> {
        BlockBuilder block = REGISTRATE.block("imposter_" + object.getId().m_135815_(), template.factory).initialProperties(NonNullSupplier.of((Supplier)((Object)object)));
        return template.model.apply((BlockBuilder<? extends Block, Registrate>)block, object.getId()).register();
    });
    private static final TemplateBuilder<StairBlock, ModelGenUtil.TextureType> STAIR_TEMPLATES = new TemplateBuilder().add(Blocks.f_50074_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50224_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50574_, ModelGenUtil.TextureType.normal()).add(RUSTY_PAINTED_METAL, ModelGenUtil.TextureType.normal()).add(Blocks.f_152544_, ModelGenUtil.TextureType.normal());
    private static final TemplateBuilder<SlabBlock, ModelGenUtil.TextureType> SLAB_TEMPLATES = new TemplateBuilder().add(Blocks.f_50074_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50224_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50574_, ModelGenUtil.TextureType.normal()).add(RUSTY_PAINTED_METAL, ModelGenUtil.TextureType.normal()).add(Blocks.f_152544_, ModelGenUtil.TextureType.normal());
    private static final TemplateBuilder<FenceBlock, ModelGenUtil.TextureType> FENCE_TEMPLATES = new TemplateBuilder().add(Blocks.f_50074_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50333_, ModelGenUtil.TextureType.sideTopSuffix()).add(Blocks.f_50069_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50222_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50224_, ModelGenUtil.TextureType.normal()).add(RUSTY_PAINTED_METAL, ModelGenUtil.TextureType.normal());
    private static final TemplateBuilder<WallBlock, ModelGenUtil.TextureType> WALL_TEMPLATES = new TemplateBuilder().add(Blocks.f_50074_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50333_, ModelGenUtil.TextureType.sideTopSuffix()).add(Blocks.f_50069_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50224_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50387_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50175_, ModelGenUtil.TextureType.normal()).add(Blocks.f_50281_, ModelGenUtil.TextureType.normal()).add(RUSTY_PAINTED_METAL, ModelGenUtil.TextureType.normal());
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends StairBlock>> STAIRS = STAIR_TEMPLATES.build((object, textureType) -> ((BlockBuilder)REGISTRATE.block(object.getId().m_135815_() + "_stairs", p -> new StairBlock(() -> ((Block)object.get()).m_49966_(), p)).initialProperties(NonNullSupplier.of((Supplier)((Object)object))).tag(new TagKey[]{BlockTags.f_13030_}).blockstate(ModelGenUtil.stairsBlock(object, textureType)).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register());
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends SlabBlock>> SLABS = SLAB_TEMPLATES.build((object, textureType) -> ((BlockBuilder)REGISTRATE.block(object.getId().m_135815_() + "_slab", SlabBlock::new).initialProperties(NonNullSupplier.of((Supplier)((Object)object))).tag(new TagKey[]{BlockTags.f_13030_}).blockstate(ModelGenUtil.slabBlock(object, textureType)).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register());
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends FenceBlock>> FENCES = FENCE_TEMPLATES.build((block, textureType) -> ((BlockBuilder)REGISTRATE.block(block.getId().m_135815_() + "_fence", FenceBlock::new).initialProperties(NonNullSupplier.of((Supplier)((Object)block))).tag(new TagKey[]{BlockTags.f_13039_}).blockstate(ModelGenUtil.fenceBlock(block, textureType)).item().tag(new TagKey[]{ItemTags.f_13147_}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), ModelGenUtil.getMainTexture(block, textureType))).build()).register());
    public static final Map<NamedSupplier<Block>, BlockEntry<? extends WallBlock>> WALLS = WALL_TEMPLATES.build((block, textureType) -> ((BlockBuilder)REGISTRATE.block(block.getId().m_135815_() + "_wall", WallBlock::new).initialProperties(NonNullSupplier.of((Supplier)((Object)block))).tag(new TagKey[]{BlockTags.f_13032_}).blockstate(ModelGenUtil.wallBlock(block, textureType)).item().tag(new TagKey[]{ItemTags.f_13140_}).model((ctx, prov) -> prov.wallInventory(ctx.getName(), ModelGenUtil.getMainTexture(block, textureType))).build()).register());
    public static final BlockEntry<Block> GREEN_ANEMONE = ExtraBlocks.anemoneBlock("green_anemone");
    public static final BlockEntry<Block> PURPLE_ANEMONE = ExtraBlocks.anemoneBlock("purple_anemone");
    public static final BlockEntry<BaseCoralFanBlock> ANEMONE_TENTACLES = ((BlockBuilder)REGISTRATE.block("anemone_tentacles", BaseCoralFanBlock::new).initialProperties(() -> Blocks.f_50553_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "block/coral_fan")).texture("fan", prov.modLoc("block/" + ctx.getName())))).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx)).build()).register();
    public static final BlockEntry<CustomSeagrassBlock> CYMODOCEA_ROTUNDATA = ExtraBlocks.seagrass("cymodocea_rotundata");
    public static final BlockEntry<CustomSeagrassBlock> CYMODOCEA_SERRULATA = ExtraBlocks.seagrass("cymodocea_serrulata");
    public static final BlockEntry<CustomSeagrassBlock> ENHALUS_ACOROIDES = ExtraBlocks.seagrass("enhalus_acoroides", () -> TALL_ENHALUS_ACOROIDES);
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_ENHALUS_ACOROIDES = CustomTallSeagrassBlock.dropping(ENHALUS_ACOROIDES).register();
    public static final BlockEntry<Block> MATTED_ENHALUS_ACOROIDES = ExtraBlocks.mattedSeagrassBlock("enhalus_acoroides");
    public static final BlockEntry<Block> ENHALUS_ACOROIDES_BLOCK = ExtraBlocks.seagrassBlock("enhalus_acoroides");
    public static final BlockEntry<CustomSeagrassBlock> HALODULE_PINIFOLIA = ExtraBlocks.seagrass("halodule_pinifolia");
    public static final BlockEntry<CustomSeagrassBlock> HALODULE_UNINERVIS = ExtraBlocks.seagrass("halodule_uninervis", () -> TALL_HALODULE_UNINERVIS);
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_HALODULE_UNINERVIS = CustomTallSeagrassBlock.dropping(HALODULE_UNINERVIS).register();
    public static final BlockEntry<Block> MATTED_HALODULE_UNINERVIS = ExtraBlocks.mattedSeagrassBlock("halodule_uninervis");
    public static final BlockEntry<Block> HALODULE_UNINERVIS_BLOCK = ExtraBlocks.seagrassBlock("halodule_uninervis");
    public static final BlockEntry<CustomSeagrassBlock> HALOPHILA_OVALIS = ExtraBlocks.seagrass("halophila_ovalis");
    public static final BlockEntry<CustomSeagrassBlock> HALOPHILA_SPINULOSA = ExtraBlocks.seagrass("halophila_spinulosa", () -> TALL_HALOPHILA_SPINULOSA);
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_HALOPHILA_SPINULOSA = CustomTallSeagrassBlock.dropping(HALOPHILA_SPINULOSA).register();
    public static final BlockEntry<Block> MATTED_HALOPHILA_SPINULOSA = ExtraBlocks.mattedSeagrassBlock("halophila_spinulosa");
    public static final BlockEntry<Block> HALOPHILA_SPINULOSA_BLOCK = ExtraBlocks.seagrassBlock("halophila_spinulosa");
    public static final BlockEntry<CustomSeagrassBlock> SYRINGODIUM_ISOETIFOLIUM = ExtraBlocks.seagrass("syringodium_isoetifolium");
    public static final BlockEntry<Block> MATTED_SYRINGODIUM_ISOETIFOLIUM = ExtraBlocks.mattedSeagrassBlock("syringodium_isoetifolium");
    public static final BlockEntry<Block> SYRINGODIUM_ISOETIFOLIUM_BLOCK = ExtraBlocks.seagrassBlock("syringodium_isoetifolium");
    public static final BlockEntry<CustomSeagrassBlock> THALASSIA_HEMPRICHII = ExtraBlocks.seagrass("thalassia_hemprichii");
    public static final BlockEntry<CustomSeagrassBlock> THALASSODENDRON_CILIATUM = ExtraBlocks.seagrass("thalassodendron_ciliatum", () -> TALL_THALASSODENDRON_CILIATUM);
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_THALASSODENDRON_CILIATUM = CustomTallSeagrassBlock.dropping(THALASSODENDRON_CILIATUM).register();
    public static final BlockEntry<Block> MATTED_THALASSODENDRON_CILIATUM = ExtraBlocks.mattedSeagrassBlock("thalassodendron_ciliatum");
    public static final BlockEntry<Block> THALASSODENDRON_CILIATUM_BLOCk = ExtraBlocks.seagrassBlock("thalassodendron_ciliatum");
    public static final BlockEntry<SubmergedLilyBlock> SUBMERGED_LILY_PAD = ((BlockBuilder)REGISTRATE.block("submerged_lily_pad", SubmergedLilyBlock::new).lang("Submerged Lily Pad").initialProperties(() -> Blocks.f_50196_).color(() -> () -> (state, level, pos, index) -> level != null && pos != null ? 2129968 : 7455580).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("submerged_lily_pad")).ao(false)).texture("particle", "minecraft:block/lily_pad")).texture("texture", "minecraft:block/lily_pad")).element().from(0.0f, 16.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).texture("#texture").tintindex(0).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#texture").tintindex(0).end().end();
        prov.getVariantBuilder((Block)ctx.getEntry()).partialState().setModels(ConfiguredModel.builder().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270).build());
    }).item((submergedLilyBlock, properties) -> new BlockItem((Block)submergedLilyBlock, (Item.Properties)properties){

        public InteractionResult m_6225_(UseOnContext ctx) {
            return InteractionResult.PASS;
        }

        public InteractionResult m_40576_(BlockPlaceContext pContext) {
            return pContext.m_43725_().m_6425_(pContext.m_8083_()).m_192917_((Fluid)Fluids.f_76193_) ? super.m_40576_(pContext) : InteractionResult.FAIL;
        }

        public InteractionResultHolder<ItemStack> m_7203_(Level leve, Player player, InteractionHand hand) {
            BlockHitResult fluidHit = 4.m_41435_((Level)leve, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            InteractionResult result = super.m_6225_(new UseOnContext(player, hand, fluidHit));
            return new InteractionResultHolder(result, (Object)player.m_21120_(hand));
        }
    }).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("minecraft:item/generated"))).texture("layer0", "minecraft:block/lily_pad")).build()).register();
    public static final BlockEntry<Block> GRASS_GRASS = ((BlockBuilder)REGISTRATE.block("grass_grass", Block::new).initialProperties(() -> Blocks.f_50440_).blockstate((ctx, prov) -> {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
        ModelBuilder grassModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.mcLoc("block/grass_block"))).texture("down", prov.mcLoc("block/grass_block_top"))).texture("up", prov.mcLoc("block/grass_block_top"))).texture("north", prov.mcLoc("block/grass_block_top"))).texture("south", prov.mcLoc("block/grass_block_top"))).texture("west", prov.mcLoc("block/grass_block_top"))).texture("east", prov.mcLoc("block/grass_block_top"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture("#top").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(direction).tintindex(0)).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)grassModel).addModel()).end();
    }).color(() -> () -> (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_()).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/grass_block"))).texture("down", prov.mcLoc("block/grass_block_top"))).texture("up", prov.mcLoc("block/grass_block_top"))).texture("north", prov.mcLoc("block/grass_block_top"))).texture("south", prov.mcLoc("block/grass_block_top"))).texture("west", prov.mcLoc("block/grass_block_top"))).texture("east", prov.mcLoc("block/grass_block_top"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.texture("#top").uvs(0.0f, 0.0f, 16.0f, 16.0f).tintindex(0).cullface(direction)).end()).build()).register();
    public static final BlockEntry<CurtainBlock> CURTAIN = ((BlockBuilder)REGISTRATE.block("curtain", p -> new CurtainBlock((BlockBehaviour.Properties)p){}).initialProperties(() -> Blocks.f_50185_).tag(new TagKey[]{ExtraTags.Blocks.CREATE_MOVABLE_EMPTY_COLLIDER}).properties(p -> p.m_60918_(SoundType.f_56745_)).blockstate((ctx, prov) -> {}).addLayer(() -> RenderType::m_110451_).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx)).build()).register();

    private static BlockEntry<GirderBlock> steelGirder(String name) {
        return REGISTRATE.block((String)(name.isEmpty() ? name : name + "_") + "steel_girder", p -> new GirderBlock(ExtraTags.Blocks.STEEL_GIRDERS, (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.f_50183_).tag(new TagKey[]{ExtraTags.Blocks.STEEL_GIRDERS}).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}).blockstate(ModelGenUtil::steelGirderBlockstate).simpleItem().register();
    }

    private static final BlockBuilder<LadderBlock, Registrate> ladder(String name, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new LadderBlock((BlockBehaviour.Properties)p){}).initialProperties(() -> Blocks.f_50183_).tag(new TagKey[]{BlockTags.f_13082_}).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}).blockstate((ctx, prov) -> prov.horizontalBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "block/ladder")).texture("texture", prov.modLoc("block/" + texture))).texture("particle", "#texture"))).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/" + texture))).build();
    }

    private static BlockBuilder<RopeBlock, Registrate> rope(String name) {
        return (BlockBuilder)REGISTRATE.block(name, RopeBlock::new).properties(p -> p.m_284180_(MapColor.f_283930_).m_60966_().m_60910_().m_60918_(SoundType.f_56745_).m_278183_()).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Object modelName = (Boolean)state.m_61143_((Property)RopeBlock.KNOT) != false ? name + "_knot" : name;
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cross((String)modelName, prov.modLoc("block/" + (String)modelName))).build();
        }, new Property[]{RopeBlock.WATERLOGGED})).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13082_}).item().model((ctx, prov) -> prov.generated(() -> ((DataGenContext)ctx).getEntry(), new ResourceLocation[]{prov.modLoc("block/" + name + "_knot")})).build();
    }

    private static BlockEntry<Block> anemoneBlock(String name) {
        return REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50186_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(ctx.getName(), prov.modLoc("block/" + ctx.getName() + "_side"), prov.modLoc("block/" + ctx.getName() + "_top")))).simpleItem().register();
    }

    private static BlockEntry<CustomSeagrassBlock> seagrass(String blockName) {
        return ExtraBlocks.seagrass(blockName, null);
    }

    private static BlockEntry<CustomSeagrassBlock> seagrass(String blockName, @Nullable Supplier<Supplier<? extends TallSeagrassBlock>> tall) {
        return ((BlockBuilder)REGISTRATE.block(blockName, p -> new CustomSeagrassBlock((BlockBehaviour.Properties)p, RegistrateLangProvider.toEnglishName((String)blockName), tall)).lang("Seagrass").initialProperties(() -> Blocks.f_50037_).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "block/template_seagrass")).texture("texture", prov.blockTexture((Block)ctx.getEntry()))).texture("particle", prov.blockTexture((Block)ctx.getEntry())))).addLayer(() -> RenderType::m_110463_).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx)).build()).register();
    }

    private static BlockEntry<Block> seagrassBlock(String name) {
        String scientificName = RegistrateLangProvider.toEnglishName((String)name);
        return REGISTRATE.block(name + "_block", properties -> new ScientificNameBlock((BlockBehaviour.Properties)properties, scientificName)).initialProperties(() -> Blocks.f_49992_).lang("Seagrass Block").blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/matted_" + name + "_top")))).simpleItem().register();
    }

    private static BlockEntry<Block> mattedSeagrassBlock(String name) {
        String scientificName = RegistrateLangProvider.toEnglishName((String)name);
        return REGISTRATE.block("matted_" + name, properties -> new ScientificNameBlock((BlockBehaviour.Properties)properties, scientificName)).initialProperties(() -> Blocks.f_49992_).lang("Matted Seagrass Block").blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/" + ctx.getName() + "_side"), prov.modLoc("block/purified_sand"), prov.modLoc("block/" + ctx.getName() + "_top")))).simpleItem().register();
    }

    public static void init() {
    }

    public static final class TemplateBuilder<T extends Block, P> {
        private final Map<NamedSupplier<Block>, P> templates = new Object2ObjectOpenHashMap();

        public TemplateBuilder<T, P> add(Block block, P parameter) {
            return this.add(NamedSupplier.of(ForgeRegistries.BLOCKS, ForgeRegistries.BLOCKS.getKey((Object)block)), parameter);
        }

        public TemplateBuilder<T, P> add(ResourceLocation id, P parameter) {
            NamedSupplier<Block> block = NamedSupplier.of(ForgeRegistries.BLOCKS, id);
            return this.add(block, parameter);
        }

        public TemplateBuilder<T, P> add(BlockEntry<Block> block, P parameter) {
            return this.add(NamedSupplier.of(block), parameter);
        }

        public TemplateBuilder<T, P> add(NamedSupplier<Block> block, P parameter) {
            String namespace = block.getId().m_135827_();
            if (ModList.get().isLoaded(namespace)) {
                this.templates.put(block, parameter);
            } else if (DatagenModLoader.isRunningDataGen()) {
                throw new UnsupportedOperationException("All soft-dependent mods must be present for datagen! Missing: " + namespace);
            }
            return this;
        }

        public Map<NamedSupplier<Block>, BlockEntry<? extends T>> build(BiFunction<NamedSupplier<Block>, P, BlockEntry<? extends T>> factory) {
            return this.templates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (BlockEntry)factory.apply((NamedSupplier)entry.getKey(), entry.getValue())));
        }
    }
}

