/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.client.command.RenderPlayerNameTagCommand;
import com.lovetropics.extras.client.entity.model.RaveKoaModel;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.collectible.CollectibleCommand;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.command.GenerateCommand;
import com.lovetropics.extras.command.PoiCommand;
import com.lovetropics.extras.command.SetMaxPlayersCommand;
import com.lovetropics.extras.command.TpCommand;
import com.lovetropics.extras.command.WarpCommand;
import com.lovetropics.extras.data.spawnitems.SpawnItemsCommand;
import com.lovetropics.extras.data.spawnitems.SpawnItemsStore;
import com.lovetropics.extras.effect.ExtraEffects;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.item.ExtraItemProperties;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.schedule.PlayerTimeZone;
import com.lovetropics.extras.translation.TranslationOptions;
import com.lovetropics.extras.world_effect.WorldEffectCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.providers.ProviderType;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod(value="ltextras")
public class LTExtras {
    public static final String MODID = "ltextras";
    private static final ResourceLocation TAB_ID = new ResourceLocation("ltextras", "ltextras");
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)TAB_ID);
    private static final NonNullLazy<Registrate> REGISTRATE = NonNullLazy.of(() -> (Registrate)Registrate.create((String)MODID).defaultCreativeTab(TAB_KEY));
    public static final Capability<CollectibleStore> COLLECTIBLE_STORE = CapabilityManager.get((CapabilityToken)new CapabilityToken<CollectibleStore>(){});
    public static final Capability<SpawnItemsStore> SPAWN_ITEMS_STORE = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpawnItemsStore>(){});
    public static final Capability<PlayerTimeZone> PLAYER_TIME_ZONE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerTimeZone>(){});
    public static final Capability<TranslationOptions> TRANSLATION = CapabilityManager.get((CapabilityToken)new CapabilityToken<TranslationOptions>(){});
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    public LTExtras() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(LTExtras::getCompatVersion, (s, v) -> LTExtras.isCompatibleVersion(s)));
        ExtraBlocks.init();
        ExtraItems.init();
        ExtraEntities.init();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtraParticles.REGISTER.register(modBus);
        ExtraEffects.REGISTER.register(modBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(this::clientSetup);
            modBus.addListener(this::registerItemColors);
            modBus.addListener(this::registerLayerDefinitions);
        });
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterClientCommands);
        ExtraLangKeys.init(LTExtras.registrate());
        ((Registrate)LTExtras.registrate().addDataGenerator(ProviderType.LANG, p -> {
            p.add((MobEffect)ExtraEffects.FISH_EYE.get(), "Fish Eye");
            p.add("toast.collectible.title", "New Collectible!");
            p.add("toast.collectible.item", " + %s");
            p.add("spawnitems.set_not_restorable", "The spawn item set %s cannot be restored!");
            p.add("spawnitems.unknown_set", "Unknown spawn item set: %s");
            p.add("spawnitems.restored_successfully", "Items restored!");
            TpCommand.addTranslations(p);
            WarpCommand.addTranslations(p);
            RenderPlayerNameTagCommand.addTranslations(p);
        })).generic(TAB_ID.m_135815_(), Registries.f_279569_, () -> CreativeModeTab.builder().m_257941_((Component)LTExtras.registrate().addLang("itemGroup", TAB_ID, "LTExtras")).m_257737_(() -> ExtraBlocks.BUOY.asStack()).m_257652_()).build();
        LTExtrasNetwork.register();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtrasConfig.COMMON_CONFIG);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExtrasConfig.CLIENT_CONFIG);
        ModList.get().getModContainerById("worldedit").ifPresent(worldedit -> {
            ModContainer previousContainer = modLoadingContext.getActiveContainer();
            try {
                modLoadingContext.setActiveContainer(worldedit);
                modLoadingContext.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
            }
            finally {
                modLoadingContext.setActiveContainer(previousContainer);
            }
        });
    }

    public static String getCompatVersion() {
        return LTExtras.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return LTExtras.getCompatVersion().equals(LTExtras.getCompatVersion(version));
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext buildContext = event.getBuildContext();
        SetMaxPlayersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        GenerateCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CollectibleCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        SpawnItemsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WorldEffectCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WarpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        PoiCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        RenderPlayerNameTagCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ForgeConfig.CLIENT.alwaysSetupTerrainOffThread.set((Object)true);
        ((ForgeConfigSpec)ObfuscationReflectionHelper.getPrivateValue(ForgeConfig.class, null, (String)"clientSpec")).save();
        ExtraItemProperties.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        evt.getItemColors().m_92689_((stack, index) -> index == 0 ? 4159204 : -1, new ItemLike[]{(ItemLike)ExtraBlocks.WATER_BARRIER.get(), (ItemLike)ExtraBlocks.FAKE_WATER.get()});
        evt.getItemColors().m_92689_((stack, index) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return evt.getBlockColors().m_92577_(blockstate, null, null, index);
        }, new ItemLike[]{ExtraBlocks.SUBMERGED_LILY_PAD.m_5456_()});
        evt.getItemColors().m_92689_((stack, index) -> 9551190, new ItemLike[]{(ItemLike)ExtraBlocks.GRASS_GRASS.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RaveKoaModel.LAYER_LOCATION, RaveKoaModel::createBodyLayer);
    }
}

