/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public final class CustomSugarCaneBlock
extends Block
implements SimpleWaterloggedBlock,
IPlantable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public CustomSugarCaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TYPE, (Comparable)((Object)Type.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        FluidState fluid = level.m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)this.getTypeAt((LevelAccessor)level, context.m_8083_())))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)this.getTypeAt(level, pos)));
    }

    private Type getTypeAt(LevelAccessor world, BlockPos pos) {
        BlockState aboveState = world.m_8055_(pos.m_7494_());
        if (aboveState.m_60713_((Block)this)) {
            BlockState belowState = world.m_8055_(pos.m_7495_());
            if (belowState.m_60713_((Block)this) || aboveState.m_61143_(TYPE) == Type.TOP) {
                return Type.MIDDLE;
            }
            return Type.BOTTOM;
        }
        return Type.TOP;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundState = world.m_8055_(groundPos);
        if (groundState.canSustainPlant((BlockGetter)world, groundPos, Direction.UP, (IPlantable)this)) {
            return true;
        }
        return groundState.m_60734_() == this || this.canGrowOn(groundState);
    }

    private boolean canGrowOn(BlockState state) {
        return state.m_60713_(Blocks.f_50440_) || state.m_204336_(BlockTags.f_13029_) || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(Tags.Blocks.GRAVEL) || state.m_60713_(Blocks.f_50129_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TYPE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }

    public static enum Type implements StringRepresentable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

