/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GirderBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Map<Direction.Axis, BooleanProperty> PROPS = (Map)Arrays.stream(Direction.Axis.values()).collect(Maps.toImmutableEnumMap(Function.identity(), a -> BooleanProperty.m_61465_((String)a.m_122477_())));
    public static final Map<Direction.Axis, VoxelShape> BASE_SHAPES = ImmutableMap.builder().put((Object)Direction.Axis.X, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.0, (double)16.0, (double)13.0, (double)11.0)).put((Object)Direction.Axis.Y, (Object)Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0)).put((Object)Direction.Axis.Z, (Object)Block.m_49796_((double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)16.0)).build();
    private final LazyLoadedValue<Map<BlockState, VoxelShape>> ALL_SHAPES = new LazyLoadedValue(() -> this.m_49965_().m_61056_().stream().collect(Collectors.toMap(Function.identity(), s -> {
        VoxelShape ret = Shapes.m_83040_();
        for (Direction.Axis a : Direction.Axis.values()) {
            if (!((Boolean)s.m_61143_((Property)PROPS.get(a))).booleanValue()) continue;
            ret = Shapes.m_83110_((VoxelShape)ret, (VoxelShape)BASE_SHAPES.get(a));
        }
        return ret;
    })));
    private final TagKey<Block> connectionTag;

    public GirderBlock(TagKey<Block> connectionTag, BlockBehaviour.Properties properties) {
        super(properties);
        this.connectionTag = connectionTag;
        this.m_49959_((BlockState)PROPS.keySet().stream().reduce((BlockState)this.m_49965_().m_61090_(), (s, a) -> (BlockState)s.m_61124_((Property)PROPS.get(a), (Comparable)Boolean.valueOf(false)), (s1, s2) -> s1).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])PROPS.values().toArray(new BooleanProperty[0])).m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (VoxelShape)((Map)this.ALL_SHAPES.m_13971_()).get(state);
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean connected = false;
        for (Direction dir : Direction.values()) {
            if (!context.m_43725_().m_8055_(context.m_8083_().m_121945_(dir)).m_204336_(this.connectionTag)) continue;
            state = (BlockState)state.m_61124_((Property)PROPS.get(dir.m_122434_()), (Comparable)Boolean.valueOf(true));
            connected = true;
        }
        if (!connected) {
            state = (BlockState)state.m_61124_((Property)PROPS.get(context.m_43719_().m_122434_()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        BlockState ret = stateIn;
        boolean connected = false;
        for (Direction.Axis a : Direction.Axis.values()) {
            if (worldIn.m_8055_(currentPos.m_121945_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)a))).m_204336_(this.connectionTag) || worldIn.m_8055_(currentPos.m_121945_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)a))).m_204336_(this.connectionTag)) {
                connected = true;
                ret = (BlockState)ret.m_61124_((Property)PROPS.get(a), (Comparable)Boolean.valueOf(true));
                continue;
            }
            ret = (BlockState)ret.m_61124_((Property)PROPS.get(a), (Comparable)Boolean.valueOf(false));
        }
        if (!connected) {
            return stateIn;
        }
        return ret;
    }
}

