/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MobControllerBlockEntity
extends BlockEntity {
    public boolean loadState = true;
    public final List<UUID> uuids = new ArrayList<UUID>();
    public final Map<UUID, EntityType<?>> types = new HashMap();
    public final Map<UUID, Vec3> positions = new HashMap<UUID, Vec3>();

    public MobControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag mobUuids = tag.m_128437_("Mobs", 10);
        this.uuids.clear();
        for (Tag mobNbt : mobUuids) {
            CompoundTag compoundNBT = (CompoundTag)mobNbt;
            UUID uuid = compoundNBT.m_128342_("UUID");
            ResourceLocation type = new ResourceLocation(compoundNBT.m_128461_("Type"));
            ListTag pos = compoundNBT.m_128437_("Pos", 6);
            this.f_58857_.m_9598_().m_175515_(Registries.f_256939_).m_6612_(type).ifPresent(entityType -> {
                this.uuids.add(uuid);
                this.types.put(uuid, (EntityType<?>)entityType);
                this.positions.put(uuid, new Vec3(pos.m_128772_(0), pos.m_128772_(1), pos.m_128772_(2)));
            });
        }
        this.loadState = tag.m_128471_("LoadState");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag mobs = new ListTag();
        for (UUID uuid : this.uuids) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128362_("UUID", uuid);
            compoundNBT.m_128359_("Type", EntityType.m_20613_(this.types.get(uuid)).toString());
            Vec3 pos = this.positions.get(uuid);
            compoundNBT.m_128365_("Pos", (Tag)this.newDoubleNBTList(pos.f_82479_, pos.f_82480_, pos.f_82481_));
            mobs.add((Object)compoundNBT);
        }
        compound.m_128365_("Mobs", (Tag)mobs);
        compound.m_128379_("LoadState", this.loadState);
    }

    protected ListTag newDoubleNBTList(double ... numbers) {
        ListTag listnbt = new ListTag();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listnbt;
    }

    public void addEntity(Entity entity) {
        if (entity instanceof ExtendedCreatureEntity) {
            ExtendedCreatureEntity ex = (ExtendedCreatureEntity)entity;
            ex.linkToBlockEntity(this);
            UUID uuid = entity.m_20148_();
            this.uuids.add(uuid);
            this.types.put(uuid, entity.m_6095_());
            this.positions.put(uuid, entity.m_20182_());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MobControllerBlockEntity controller) {
        block6: {
            Player player;
            ServerLevel serverLevel;
            block7: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                long ticks = level.m_46467_();
                if (controller.loadState && ticks % 5L == 0L) {
                    for (UUID uuid : controller.uuids) {
                        Entity entity = serverLevel.m_8791_(uuid);
                        if (entity == null) continue;
                        controller.positions.put(uuid, entity.m_20182_());
                    }
                }
                if (ticks % 20L != 0L) break block6;
                player = level.m_5788_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 32.0, EntitySelector.f_20408_);
                if (!controller.loadState) break block7;
                if (player != null) break block6;
                controller.loadState = false;
                for (UUID uuid : controller.uuids) {
                    Entity entity = serverLevel.m_8791_(uuid);
                    if (entity == null) continue;
                    entity.m_146870_();
                }
                break block6;
            }
            if (player != null) {
                controller.loadState = true;
                for (UUID uuid : controller.uuids) {
                    Entity entity = controller.types.get(uuid).m_20615_((Level)serverLevel);
                    Vec3 mobPos = controller.positions.get(uuid);
                    if (entity == null) continue;
                    entity.m_7678_(mobPos.m_7096_(), mobPos.m_7098_(), mobPos.m_7094_(), 0.0f, 0.0f);
                    entity.m_20084_(uuid);
                    level.m_7967_(entity);
                    if (entity instanceof Mob) {
                        ((Mob)entity).m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                    }
                    if (!(entity instanceof ExtendedCreatureEntity)) continue;
                    ((ExtendedCreatureEntity)entity).linkToBlockEntity(controller);
                }
            }
        }
    }
}

