/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.client.CollectibleToast;
import com.lovetropics.extras.client.screen.container.CollectibleBasketScreen;
import com.lovetropics.extras.collectible.Collectible;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ClientCollectiblesList {
    private static ClientCollectiblesList instance;
    private List<Collectible> collectibles = List.of();
    private List<ItemStack> itemStacks = List.of();
    private boolean hasUnseen;

    public static ClientCollectiblesList get() {
        return Objects.requireNonNull(instance, "Cannot get collectibles list, not currently in a world");
    }

    @Nullable
    public static ClientCollectiblesList getOrNull() {
        return instance;
    }

    @SubscribeEvent
    public static void onLogIn(ClientPlayerNetworkEvent.LoggingIn event) {
        instance = new ClientCollectiblesList();
    }

    @SubscribeEvent
    public static void onLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        instance = null;
    }

    public List<Collectible> collectibles() {
        return this.collectibles;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public void update(List<Collectible> collectibles, boolean silent, boolean hasUnseen) {
        Minecraft minecraft = Minecraft.m_91087_();
        List<Collectible> newCollectibles = collectibles.stream().filter(c -> !this.collectibles.contains(c)).toList();
        this.collectibles = List.copyOf(collectibles);
        UUID playerId = minecraft.f_91074_.m_20148_();
        this.itemStacks = collectibles.stream().map(collectible -> collectible.createItemStack(playerId)).toList();
        if (!silent && !newCollectibles.isEmpty()) {
            ClientCollectiblesList.notifyCollections(newCollectibles);
        }
        this.hasUnseen = hasUnseen;
    }

    private static void notifyCollections(List<Collectible> newCollectibles) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (Collectible newCollectible : newCollectibles) {
            minecraft.m_91300_().m_94922_((Toast)new CollectibleToast(newCollectible));
        }
        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11871_, (float)1.0f));
    }

    public static void openScreen() {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91152_((Screen)new CollectibleBasketScreen(minecraft.f_91074_.m_150109_()));
        ClientCollectiblesList.get().hasUnseen = false;
    }

    public boolean isEmpty() {
        return this.collectibles.isEmpty();
    }

    public boolean hasUnseen() {
        return this.hasUnseen;
    }
}

