/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.client.screen.map.TropicalMapScreen;
import com.lovetropics.extras.data.poi.Poi;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ClientMapPoiManager {
    private static final Map<String, Poi> POIS = new HashMap<String, Poi>();

    public static void updatePoi(Poi poi, boolean delete) {
        if (delete) {
            POIS.remove(poi.name());
        } else {
            POIS.put(poi.name(), poi);
        }
    }

    public static Map<String, Poi> getPois() {
        return POIS;
    }

    public static void openScreen(Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new TropicalMapScreen((Component)Component.m_237115_((String)"item.ltextras.tropical_map"), player));
    }

    @SubscribeEvent
    public static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        POIS.clear();
    }

    public static ResourceLocation getFace(UUID uuid) {
        return ClientMapPoiManager.getPlayerSkinOrDefault(uuid);
    }

    private static ResourceLocation getPlayerSkinOrDefault(UUID uuid) {
        PlayerInfo playerInfo;
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null || (playerInfo = connection.m_104949_(uuid)) == null) {
            return DefaultPlayerSkin.m_118627_((UUID)uuid);
        }
        return playerInfo.m_105337_();
    }
}

