/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.item.ImageData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class ImageRenderer {
    @SubscribeEvent
    public static void onRenderItemInFrame(RenderItemInFrameEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_150930_((Item)ExtraItems.IMAGE.get())) {
            return;
        }
        ImageData image = ImageData.get(stack).orElse(null);
        if (image != null) {
            ImageRenderer.renderImage(image, event.getPoseStack().m_85850_(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    private static void renderImage(ImageData image, PoseStack.Pose pose, MultiBufferSource bufferSource, int packedLight) {
        float x0 = -image.width() / 2.0f + image.offsetX();
        float y0 = -image.height() / 2.0f + image.offsetY();
        float x1 = image.width() / 2.0f + image.offsetX();
        float y1 = image.height() / 2.0f + image.offsetY();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110464_((ResourceLocation)image.texture()));
        ImageRenderer.addVertex(consumer, pose, x0, y0, 1.0f, 1.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x1, y0, 0.0f, 1.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x1, y1, 0.0f, 0.0f, packedLight);
        ImageRenderer.addVertex(consumer, pose, x0, y1, 1.0f, 0.0f, packedLight);
    }

    private static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float u, float v, int packedLight) {
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        consumer.m_252986_(matrix, x, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
    }
}

