/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.item.ImageData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InviteOverlay {
    private static final int PADDING = 10;

    @SubscribeEvent
    public static void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        event.registerAbove(VanillaGuiOverlay.CHAT_PANEL.id(), "invites", (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            ItemStack item = player.m_21205_();
            if (item.m_150930_((Item)ExtraItems.INVITE.get())) {
                ImageData.get(item).ifPresent(image -> InviteOverlay.drawImage(graphics, gui.m_93082_(), screenWidth, screenHeight, image));
            }
        });
    }

    private static void drawImage(GuiGraphics graphics, Font font, int screenWidth, int screenHeight, ImageData image) {
        int height = Math.min((int)image.height(), screenHeight - 20);
        float scale = (float)height / image.height();
        int width = Mth.m_14143_((float)(image.width() * scale));
        int left = (screenWidth - width) / 2;
        int top = (screenHeight - height) / 2;
        graphics.m_280411_(image.texture(), left, top, width, height, 0.0f, 0.0f, 1, 1, 1, 1);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)left, (float)top, 200.0f);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        for (ImageData.TextElement text : image.text()) {
            int maxWidth = text.maxWidth() != Float.MAX_VALUE ? Mth.m_14143_((float)text.maxWidth()) : Integer.MAX_VALUE;
            List lines = font.m_92923_((FormattedText)text.text(), maxWidth);
            float textWidth = 0.0f;
            for (FormattedCharSequence line : lines) {
                textWidth = Math.max(textWidth, (float)font.m_92724_(line));
            }
            float lineSpacing = text.lineSpacing();
            float textHeight = (float)lines.size() * lineSpacing;
            float lineTop = text.alignVertical().resolve(text.y(), textHeight);
            for (FormattedCharSequence line : lines) {
                float lineLeft = text.alignHorizontal().resolve(text.x(), font.m_92724_(line));
                graphics.m_280648_(font, line, Mth.m_14143_((float)lineLeft), Mth.m_14143_((float)lineTop), -1);
                lineTop += lineSpacing;
            }
        }
        graphics.m_280168_().m_85849_();
    }
}

