/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.ExtraUtils;
import com.lovetropics.extras.entity.CollectibleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Quaternionf;

public class CollectibleEntityRenderer
extends EntityRenderer<CollectibleEntity> {
    private static final ItemDisplayContext DISPLAY_CONTEXT = ItemDisplayContext.GROUND;
    private final ItemRenderer itemRenderer;

    public CollectibleEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.f_114477_ = 0.3f;
        this.f_114478_ = 0.75f;
    }

    public void render(CollectibleEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ItemStack displayedItem = entity.getDisplayedItem();
        if (displayedItem.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        BakedModel model = this.itemRenderer.m_174264_(displayedItem, entity.m_9236_(), null, entity.m_19879_());
        float age = (float)entity.f_19797_ + partialTicks;
        float groundScale = model.m_7442_().m_269404_((ItemDisplayContext)CollectibleEntityRenderer.DISPLAY_CONTEXT).f_111757_.y();
        float bob = (Mth.m_14031_((float)(age / 10.0f)) + 1.0f) * 0.05f;
        poseStack.m_252880_(0.0f, bob + 0.4f * groundScale, 0.0f);
        poseStack.m_252781_(ExtraUtils.rotationAboutY(this.f_114476_.m_253208_(), new Quaternionf()));
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Math.PI));
        float scale = model.m_7539_() ? 2.25f : 2.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.itemRenderer.m_115143_(displayedItem, DISPLAY_CONTEXT, false, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(CollectibleEntity pEntity) {
        return TextureAtlas.f_118259_;
    }

    protected boolean shouldShowName(CollectibleEntity entity) {
        return entity.m_8077_() || entity.m_6052_() && CollectibleEntityRenderer.isEntityPicked(entity);
    }

    private static boolean isEntityPicked(Entity entity) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.m_82443_() == entity;
        }
        return false;
    }
}

