/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.ExtraUtils;
import com.lovetropics.extras.entity.HologramEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class HologramEntityRenderer
extends EntityRenderer<HologramEntity> {
    private final Font font;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final Function<Component, List<HologramEntity.Line>> textSplitter;

    public HologramEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
        this.entityRenderDispatcher = context.m_174022_();
        this.font = context.m_174028_();
        this.textSplitter = component -> this.font.m_92923_((FormattedText)component, Integer.MAX_VALUE).stream().map(text -> new HologramEntity.Line((FormattedCharSequence)text, this.font.m_92724_(text))).toList();
    }

    public void render(HologramEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        HologramEntity.DisplayInfo display = entity.display(this.textSplitter);
        poseStack.m_85836_();
        Quaternionf rotation = display.rotation();
        if (rotation != null) {
            poseStack.m_252781_(rotation);
        } else {
            poseStack.m_252781_(ExtraUtils.rotationAboutY(this.entityRenderDispatcher.m_253208_(), new Quaternionf()));
        }
        float scale = entity.scale();
        poseStack.m_85841_(-scale, -scale, scale);
        float backgroundOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundColor = Mth.m_14143_((float)(backgroundOpacity * 255.0f)) << 24;
        int textLight = entity.fullbright() ? 0xF000F0 : packedLight;
        Objects.requireNonNull(this.font);
        int lineHeight = 9 + 1;
        float lineY = (float)(-(display.lines().size() * lineHeight)) / 2.0f;
        for (HologramEntity.Line line : display.lines()) {
            this.font.m_272191_(line.text(), (float)(-line.width()) / 2.0f, lineY, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, backgroundColor, textLight);
            lineY += (float)lineHeight;
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(HologramEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

