/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.entity.vfx.PartyBeamEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PartyBeamRenderer
extends EntityRenderer<PartyBeamEntity> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)EnderDragonRenderer.f_114174_);
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)END_CRYSTAL_LOCATION);
    private static final float SIN_45 = Mth.m_14031_((float)0.7853982f);
    private final ModelPart cube;
    private final ModelPart glass;
    private final ModelPart base;

    public PartyBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        ModelPart root = context.m_174023_(ModelLayers.f_171145_);
        this.glass = root.m_171324_("glass");
        this.cube = root.m_171324_("cube");
        this.base = root.m_171324_("base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("glass", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        root.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        root.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void render(PartyBeamEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        float offsetY = PartyBeamRenderer.getY(entity, partialTicks);
        float time = ((float)entity.f_31032_ + partialTicks) * 3.0f;
        VertexConsumer consumer = bufferSource.m_6299_(RENDER_TYPE);
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        poseStack.m_252880_(0.0f, -0.5f, 0.0f);
        if (entity.m_31065_()) {
            this.base.m_104301_(poseStack, consumer, packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time));
        poseStack.m_252880_(0.0f, 1.5f + offsetY / 2.0f, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        this.glass.m_104301_(poseStack, consumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85841_(0.875f, 0.875f, 0.875f);
        poseStack.m_252781_(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time));
        this.glass.m_104301_(poseStack, consumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85841_(0.875f, 0.875f, 0.875f);
        poseStack.m_252781_(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time));
        this.cube.m_104301_(poseStack, consumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85849_();
        BlockPos target = entity.m_31064_();
        if (target != null) {
            float targetX = (float)target.m_123341_() + 0.5f;
            float targetY = (float)target.m_123342_() + 0.5f;
            float targetZ = (float)target.m_123343_() + 0.5f;
            float deltaX = (float)((double)targetX - entity.m_20185_());
            float deltaY = (float)((double)targetY - entity.m_20186_());
            float deltaZ = (float)((double)targetZ - entity.m_20189_());
            poseStack.m_252880_(deltaX, deltaY, deltaZ);
            this.renderCrystalBeams(entity, -deltaX, -deltaY + offsetY, -deltaZ, partialTicks, entity.f_31032_, poseStack, bufferSource, packedLight);
        }
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public void renderCrystalBeams(PartyBeamEntity entity, float deltaX, float deltaY, float deltaZ, float partialTicks, int time, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float lengthXz = Mth.m_14116_((float)(deltaX * deltaX + deltaZ * deltaZ));
        float length = Mth.m_14116_((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 2.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(deltaZ, deltaX)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(lengthXz, deltaY)) - 1.5707964f));
        VertexConsumer consumer = bufferSource.m_6299_(BEAM);
        float startTextureOffset = -((float)time + partialTicks) * 0.01f;
        float endTextureOffset = length / 32.0f - ((float)time + partialTicks) * 0.01f;
        float lastX = 0.0f;
        float lastY = 0.75f;
        float lastProgress = 0.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        for (int i = 1; i <= 8; ++i) {
            float x = Mth.m_14031_((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float y = Mth.m_14089_((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float progress = (float)i / 8.0f;
            Vector3f color = entity.getColor();
            int r = Mth.m_14143_((float)(color.x() * 255.0f));
            int g = Mth.m_14143_((float)(color.y() * 255.0f));
            int b = Mth.m_14143_((float)(color.z() * 255.0f));
            consumer.m_252986_(matrix, lastX * 0.2f, lastY * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(lastProgress, startTextureOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix, lastX, lastY, length).m_6122_(r, g, b, 255).m_7421_(lastProgress, endTextureOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix, x, y, length).m_6122_(r, g, b, 255).m_7421_(progress, endTextureOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix, x * 0.2f, y * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(progress, startTextureOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            lastX = x;
            lastY = y;
            lastProgress = progress;
        }
        poseStack.m_85849_();
    }

    private static float getY(PartyBeamEntity entity, float partialTicks) {
        float time = (float)entity.f_31032_ + partialTicks;
        float y = Mth.m_14031_((float)(time * 0.2f)) / 2.0f + 0.5f;
        y = (y * y + y) * 0.4f;
        return y - 1.4f;
    }

    public ResourceLocation getTextureLocation(PartyBeamEntity entity) {
        return END_CRYSTAL_LOCATION;
    }

    public boolean shouldRender(PartyBeamEntity entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        return super.m_5523_((Entity)entity, frustum, cameraX, cameraY, cameraZ) || entity.m_31064_() != null;
    }
}

