/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.container;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.client.ClientCollectiblesList;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.item.CollectibleBasketItem;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.network.PickCollectibleItemPacket;
import com.lovetropics.extras.network.ReturnCollectibleItemPacket;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CollectibleBasketScreen
extends AbstractContainerScreen<Menu> {
    private static final Component TITLE = ((CollectibleBasketItem)((Object)ExtraItems.COLLECTIBLE_BASKET.get())).m_41466_();
    private static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    private static final ResourceLocation CREATIVE_TABS_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int BACKGROUND_WIDTH = 195;
    private static final int BACKGROUND_HEIGHT = 136;
    private static final int SLOT_SIZE = 18;
    private static final int COLUMNS = 9;
    private static final int ROWS = 5;
    private static final int SCROLL_BAR_X = 175;
    private static final int SCROLL_BAR_Y = 18;
    private static final int SCROLL_BAR_HEIGHT = 110;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private float scroll;
    private boolean draggingScroller;
    private double dragOffsetY;

    public CollectibleBasketScreen(Inventory playerInventory) {
        super((AbstractContainerMenu)new Menu(playerInventory.f_35978_, new CollectibleContainer(ClientCollectiblesList.get())), playerInventory, TITLE);
        playerInventory.f_35978_.f_36096_ = this.f_97732_;
        this.f_97726_ = 195;
        this.f_97727_ = 136;
    }

    protected void m_181908_() {
        super.m_181908_();
        ((Menu)this.f_97732_).container.setScrollRowOffset(Math.round(this.clampScroll(this.scroll)));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        ScreenRectangle scroller = this.scrollerRectangle();
        if (scroller != null) {
            graphics.m_280218_(CREATIVE_TABS_LOCATION, scroller.m_274563_(), scroller.m_274449_(), this.draggingScroller ? 244 : 232, 0, scroller.f_263770_(), scroller.f_263800_());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ScreenRectangle scroller = this.scrollerRectangle();
        if (scroller != null && mouseX >= (double)scroller.m_274563_() && mouseX <= (double)scroller.m_274445_() && mouseY >= (double)scroller.m_274449_() && mouseY <= (double)scroller.m_274349_()) {
            this.draggingScroller = true;
            this.dragOffsetY = (double)scroller.m_274449_() - mouseY;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroller) {
            float targetScrollerY = (float)(mouseY + this.dragOffsetY) - 18.0f - (float)this.f_97736_;
            this.scroll = this.clampScroll(targetScrollerY / 95.0f * (float)this.maxScroll());
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.draggingScroller = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            this.scroll = this.clampScroll(this.scroll - (float)delta);
            return true;
        }
        return false;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280218_(BACKGROUND_LOCATION, this.f_97735_, this.f_97736_, 0, 0, 195, 136);
    }

    @Nullable
    private ScreenRectangle scrollerRectangle() {
        if (!this.canScroll()) {
            return null;
        }
        return new ScreenRectangle(this.f_97735_ + 175, this.f_97736_ + 18 + this.scrollerY(), 12, 15);
    }

    private int scrollerY() {
        return Math.round(this.clampScroll(this.scroll) / (float)this.maxScroll() * 95.0f);
    }

    private float clampScroll(float scroll) {
        return Mth.m_14036_((float)scroll, (float)0.0f, (float)this.maxScroll());
    }

    private boolean canScroll() {
        return this.maxScroll() > 0;
    }

    private int maxScroll() {
        return Math.max(((Menu)this.f_97732_).container.contentRows() - 5, 0);
    }

    protected void m_6597_(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof CollectibleSlot) {
            CollectibleSlot collectibleSlot = (CollectibleSlot)slot;
            switch (type) {
                case PICKUP: 
                case PICKUP_ALL: 
                case QUICK_MOVE: {
                    ItemStack carried = ((Menu)this.f_97732_).m_142621_();
                    if (carried.m_41619_()) {
                        this.tryPickCollectible(slot, collectibleSlot);
                        break;
                    }
                    this.tryReturnCollectible(carried);
                    break;
                }
            }
        } else {
            this.simulateInventorySlotClicked(slot, slotId, mouseButton, type);
        }
    }

    private void tryPickCollectible(@NotNull Slot slot, CollectibleSlot collectibleSlot) {
        Collectible collectible = collectibleSlot.getCollectible();
        if (collectible != null) {
            ((Menu)this.f_97732_).m_142503_(slot.m_7993_().m_41777_());
            LTExtrasNetwork.CHANNEL.sendToServer((Object)new PickCollectibleItemPacket(collectible));
        }
    }

    private void tryReturnCollectible(ItemStack carried) {
        Collectible carriedCollectible = Collectible.byItem(carried);
        if (carriedCollectible != null) {
            ((Menu)this.f_97732_).m_142503_(ItemStack.f_41583_);
            LTExtrasNetwork.CHANNEL.sendToServer((Object)new ReturnCollectibleItemPacket(carriedCollectible));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateInventorySlotClicked(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        LocalPlayer player = this.f_96541_.f_91074_;
        try {
            player.f_36096_ = player.f_36095_;
            Slot mappedSlot = slot != null ? CollectibleBasketScreen.getSlotIn(slot, (AbstractContainerMenu)player.f_36095_) : null;
            int mappedSlotId = mappedSlot != null ? mappedSlot.f_40219_ : slotId;
            this.f_96541_.f_91072_.m_171799_(player.f_36095_.f_38840_, mappedSlotId, mouseButton, type, (Player)player);
        }
        finally {
            player.f_36096_ = this.f_97732_;
        }
    }

    @Nullable
    private static Slot getSlotIn(Slot slot, AbstractContainerMenu menu) {
        for (Slot otherSlot : menu.f_38839_) {
            if (!slot.isSameInventory(otherSlot) || slot.m_150661_() != otherSlot.m_150661_()) continue;
            return otherSlot;
        }
        return null;
    }

    public static class Menu
    extends AbstractContainerMenu {
        private final InventoryMenu inventoryMenu;
        private final CollectibleContainer container;

        protected Menu(Player player, CollectibleContainer container) {
            super(null, player.f_36095_.f_38840_);
            this.container = container;
            this.inventoryMenu = player.f_36095_;
            Inventory playerInventory = player.m_150109_();
            for (int row = 0; row < 5; ++row) {
                for (int column = 0; column < 9; ++column) {
                    int index = column + row * 9;
                    this.m_38897_(new CollectibleSlot(container, index, 9 + column * 18, 18 + row * 18));
                }
            }
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column, 9 + column * 18, 112));
            }
        }

        public ItemStack m_7648_(Player player, int pIndex) {
            return ItemStack.f_41583_;
        }

        public boolean m_6875_(Player player) {
            return player.m_21055_((Item)ExtraItems.COLLECTIBLE_BASKET.get());
        }

        public ItemStack m_142621_() {
            return this.inventoryMenu.m_142621_();
        }

        public void m_142503_(ItemStack stack) {
            this.inventoryMenu.m_142503_(stack);
        }
    }

    public static class CollectibleContainer
    implements Container {
        private final ClientCollectiblesList list;
        private int scrollRowOffset;

        public CollectibleContainer(ClientCollectiblesList list) {
            this.list = list;
        }

        public void setScrollRowOffset(int scrollRowOffset) {
            this.scrollRowOffset = scrollRowOffset;
        }

        public int m_6643_() {
            return 45;
        }

        public boolean m_7983_() {
            return this.list.isEmpty();
        }

        @Nullable
        public Collectible getCollectible(int slot) {
            List<Collectible> collectibles = this.list.collectibles();
            int index = this.getIndexForSlot(slot);
            if (index >= 0 && index < collectibles.size()) {
                return collectibles.get(index);
            }
            return null;
        }

        public ItemStack m_8020_(int slot) {
            List<ItemStack> stacks = this.list.itemStacks();
            int index = this.getIndexForSlot(slot);
            if (index >= 0 && index < stacks.size()) {
                return stacks.get(index);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int slot, int amount) {
            return this.m_8020_(slot).m_41777_();
        }

        public ItemStack m_8016_(int slot) {
            return this.m_8020_(slot).m_41777_();
        }

        public void m_6836_(int slot, ItemStack stack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
        }

        public int contentRows() {
            return Mth.m_184652_((int)this.list.collectibles().size(), (int)9);
        }

        private int getIndexForSlot(int slot) {
            return slot + this.scrollRowOffset * 9;
        }
    }

    private static class CollectibleSlot
    extends Slot {
        private final CollectibleContainer container;

        public CollectibleSlot(CollectibleContainer container, int index, int x, int y) {
            super((Container)container, index, x, y);
            this.container = container;
        }

        public int m_6641_() {
            return 1;
        }

        @Nullable
        public Collectible getCollectible() {
            return this.container.getCollectible(this.f_40219_);
        }
    }
}

