/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.map;

import com.lovetropics.extras.client.ClientMapPoiManager;
import com.lovetropics.extras.data.poi.Poi;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

class PoiButton
extends AbstractButton {
    private static final int ICON_SIZE = 16;
    private static final int HALF_ICON_SIZE = 8;
    private static final int BORDER_SIZE = 3;
    private static final int SIZE = 22;
    private static final int TOOLTIP_HEIGHT = 18;
    private static final int HOVER_ANIMATION_LENGTH = 8;
    private static final ResourceLocation TOOLTIP_LOCATION = new ResourceLocation("textures/gui/advancements/widgets.png");
    private final Poi poi;
    private final Font font;
    private final Consumer<Poi> action;
    private int lastFocusAnimation;
    private int focusAnimation;

    private PoiButton(Font font, int x, int y, Component message, Poi poi, Consumer<Poi> action) {
        super(x, y, 22, 22, message);
        this.poi = poi;
        this.font = font;
        this.action = action;
    }

    public static PoiButton create(Font font, int x, int y, Poi poi, Consumer<Poi> action) {
        Component description = poi.description();
        if (!poi.enabled()) {
            description = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"\ud83d\udd12 ").m_130940_(ChatFormatting.RED)).m_7220_(description).m_130940_(ChatFormatting.GRAY);
        }
        return new PoiButton(font, x - 11, y - 11, description, poi, action);
    }

    public void tick() {
        this.lastFocusAnimation = this.focusAnimation;
        boolean focused = this.m_198029_();
        if (focused && this.focusAnimation < 8) {
            ++this.focusAnimation;
        } else if (!focused && this.focusAnimation > 0) {
            --this.focusAnimation;
        }
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int zOffset;
        float animation = Mth.m_14179_((float)partialTicks, (float)this.lastFocusAnimation, (float)this.focusAnimation) / 8.0f;
        int n = zOffset = (animation = (float)(1.0 - Math.pow(1.0 - (double)animation, 5.0))) > 0.0f ? 100 : 0;
        if (animation > 0.0f) {
            int tooltipWidth = Mth.m_14143_((float)((float)(this.font.m_92852_((FormattedText)this.m_6035_()) + 6) * animation));
            int tooltipHeight = 18;
            this.m_93674_(22 + tooltipWidth);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)zOffset);
            graphics.m_280260_(TOOLTIP_LOCATION, this.m_252754_(), this.m_252907_() + (this.m_93694_() - 18) / 2, this.m_5711_(), 18, 3, 200, 20, 0, 29);
            graphics.m_280260_(TOOLTIP_LOCATION, this.m_252754_(), this.m_252907_(), 22, 22, 3, 200, 20, 0, 55);
            graphics.m_280588_(this.m_252754_() + 3, this.m_252907_() + 3, this.m_252754_() + this.m_5711_() - 3, this.m_252907_() + this.m_93694_() - 3);
            int textLeft = this.m_252754_() + 22 + 3 - 1;
            int n2 = this.m_252907_();
            int n3 = this.m_93694_();
            Objects.requireNonNull(this.font);
            int textTop = n2 + (n3 - 9) / 2 + 1;
            graphics.m_280430_(this.font, this.m_6035_(), textLeft, textTop, -1);
            graphics.m_280618_();
            graphics.m_280168_().m_85849_();
        } else {
            this.m_93674_(22);
        }
        ResourceLocation icon = this.poi.resourceLocation();
        graphics.m_280398_(icon, this.m_252754_() + 3, this.m_252907_() + 3, zOffset, 0.0f, 0.0f, 16, 16, 16, 16);
        List<UUID> faces = this.poi.faces();
        if (!faces.isEmpty()) {
            int faceFactor = faces.size() > 2 ? 2 : 1;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)zOffset);
            for (int i = 0; i < faces.size(); ++i) {
                UUID uuid = faces.get(i);
                ResourceLocation face = ClientMapPoiManager.getFace(uuid);
                PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)face, (int)(this.m_252754_() + 3 + i * 8 / faceFactor + i), (int)(this.m_252907_() + 16), (int)(8 / faceFactor));
            }
            graphics.m_280168_().m_85849_();
        }
    }

    public void m_5691_() {
        this.action.accept(this.poi);
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }
}

