/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.map;

import com.lovetropics.extras.client.ClientMapPoiManager;
import com.lovetropics.extras.client.screen.map.PoiButton;
import com.lovetropics.extras.data.poi.MapPoiManager;
import com.lovetropics.extras.data.poi.Poi;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class TropicalMapScreen
extends Screen {
    private static final int MAP_PNG_HEIGHT = 256;
    private static final int MAP_PNG_WIDTH = 256;
    private static final ResourceLocation MAP_LOCATION = new ResourceLocation("ltextras", "textures/map.png");
    private final Player player;
    private final List<PoiButton> poiButtons = new ArrayList<PoiButton>();

    public TropicalMapScreen(Component title, Player player) {
        super(title);
        this.player = player;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.poiButtons.clear();
        int xOffset = this.f_96543_ / 2 - 128;
        int yOffset = this.f_96544_ / 2 - 128;
        for (Poi mapPoi : ClientMapPoiManager.getPois().values()) {
            if (!mapPoi.enabled() && !this.player.m_20310_(2)) continue;
            BlockPos pos = mapPoi.globalPos().m_122646_();
            Pair<Integer, Integer> poiPos = this.getPoiPos(pos);
            int screenX = (Integer)poiPos.getLeft() + xOffset;
            int screenY = (Integer)poiPos.getRight() + yOffset;
            PoiButton button = PoiButton.create(this.f_96547_, screenX, screenY, mapPoi, this::doWarp);
            this.m_142416_((GuiEventListener)button);
            this.poiButtons.add(button);
        }
    }

    private Pair<Integer, Integer> getPoiPos(BlockPos blockPos) {
        int mapWidth = MapPoiManager.MAP_BB.m_162399_() - MapPoiManager.MAP_BB.m_162395_();
        int mapHeight = MapPoiManager.MAP_BB.m_162401_() - MapPoiManager.MAP_BB.m_162398_();
        int screenX = (blockPos.m_123341_() - MapPoiManager.MAP_BB.m_162395_()) * 256 / mapWidth;
        int screenY = (blockPos.m_123343_() - MapPoiManager.MAP_BB.m_162398_()) * 256 / mapHeight;
        return Pair.of((Object)screenX, (Object)screenY);
    }

    public void m_86600_() {
        super.m_86600_();
        for (PoiButton button : this.poiButtons) {
            button.tick();
        }
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        int h = (this.f_96544_ - 256) / 2;
        int w = (this.f_96543_ - 256) / 2;
        guiGraphics.m_280398_(MAP_LOCATION, w, h, 0, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    private void doWarp(Poi mapPoi) {
        Player player = this.player;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            localPlayer.f_108617_.m_246979_("warp " + mapPoi.name());
            this.m_7379_();
        }
    }
}

