/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.world_effect;

import com.lovetropics.extras.client.world_effect.EffectInterpolator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class SkyColorEffectHandler {
    private static final EffectInterpolator<State> INTERPOLATOR = new EffectInterpolator<State>(State::lerp, State.NONE);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                INTERPOLATOR.step();
            } else {
                INTERPOLATOR.reset(State.NONE);
            }
        }
    }

    public static Vec3 modifyColor(Vec3 color, float partialTicks) {
        State frameState = INTERPOLATOR.get(partialTicks);
        if (frameState.alpha == 0.0f) {
            return color;
        }
        if (frameState.alpha == 1.0f) {
            return frameState.color;
        }
        return color.m_165921_(frameState.color, (double)frameState.alpha);
    }

    public static void apply(int color, int fadeLength) {
        INTERPOLATOR.setTarget(new State(new Vec3((double)FastColor.ARGB32.m_13665_((int)color) / 255.0, (double)FastColor.ARGB32.m_13667_((int)color) / 255.0, (double)FastColor.ARGB32.m_13669_((int)color) / 255.0), 1.0f), fadeLength);
    }

    public static void clear(int fadeLength) {
        INTERPOLATOR.setTarget(State.NONE, fadeLength);
    }

    private record State(Vec3 color, float alpha) {
        public static final State NONE = new State(Vec3.f_82478_, 0.0f);

        public State lerp(State target, float x) {
            return new State(this.color.m_165921_(target.color, (double)x), Mth.m_14179_((float)x, (float)this.alpha, (float)target.alpha));
        }
    }
}

