/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.world_effect;

import com.lovetropics.extras.world_effect.ParticlesEffect;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class WorldParticleEffectHandler {
    private static ParticlesEffect effect;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            effect = null;
            return;
        }
        if (effect != null && event.phase == TickEvent.Phase.START && !minecraft.m_91104_()) {
            for (ParticlesEffect.Particle particle : effect.particles()) {
                WorldParticleEffectHandler.addParticles(player.m_9236_(), player.m_217043_(), player.m_20183_(), particle);
            }
        }
    }

    private static void addParticles(Level level, RandomSource random, BlockPos playerPosition, ParticlesEffect.Particle particle) {
        int range = particle.range();
        BlockPos origin = playerPosition.m_121955_(particle.offset());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < particle.count(); ++i) {
            pos.m_122154_((Vec3i)origin, random.m_188503_(range) - random.m_188503_(range), random.m_188503_(range) - random.m_188503_(range), random.m_188503_(range) - random.m_188503_(range));
            BlockState state = level.m_8055_((BlockPos)pos);
            if (state.m_60838_((BlockGetter)level, (BlockPos)pos)) continue;
            level.m_7106_(particle.particle(), (double)((float)pos.m_123341_() + random.m_188501_()), (double)((float)pos.m_123342_() + random.m_188501_()), (double)((float)pos.m_123343_() + random.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    public static void set(@Nullable ParticlesEffect effect) {
        WorldParticleEffectHandler.effect = effect;
    }
}

