/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Collectible {
    private static final Codec<CompoundTag> TAG_CODEC = CompoundTag.f_128325_.xmap(CompoundTag::m_6426_, CompoundTag::m_6426_);
    public static final Codec<Collectible> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("item").forGetter(c -> c.item), (App)TAG_CODEC.optionalFieldOf("tag").forGetter(c -> c.tag)).apply((Applicative)i, Collectible::new));
    private static final String KEY_ITEM_STACK_MARKER = "collectible_marker";
    private final Holder<Item> item;
    private final Optional<CompoundTag> tag;

    private Collectible(Holder<Item> item, Optional<CompoundTag> tag) {
        this.item = item;
        this.tag = tag.filter(t -> !t.m_128456_());
    }

    public Collectible(ItemStack stack) {
        this((Holder<Item>)stack.m_220173_(), Optional.ofNullable(stack.m_41783_()).map(CompoundTag::m_6426_).map(t -> {
            t.m_128473_(KEY_ITEM_STACK_MARKER);
            return t;
        }));
    }

    public Collectible(FriendlyByteBuf input) {
        this((Holder<Item>)((Holder)input.m_236816_(BuiltInRegistries.f_257033_.m_206115_())), input.m_236860_(FriendlyByteBuf::m_130260_));
    }

    public void write(FriendlyByteBuf output) {
        output.m_236818_(BuiltInRegistries.f_257033_.m_206115_(), this.item);
        output.m_236835_(this.tag, FriendlyByteBuf::m_130079_);
    }

    @Nullable
    public static Collectible byItem(ItemStack stack) {
        if (Collectible.isCollectible(stack)) {
            return new Collectible(stack);
        }
        return null;
    }

    public static boolean isCollectible(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(KEY_ITEM_STACK_MARKER);
    }

    public static boolean isIllegalCollectible(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(KEY_ITEM_STACK_MARKER)) {
            return !player.m_20148_().equals(tag.m_128342_(KEY_ITEM_STACK_MARKER));
        }
        return false;
    }

    public ItemStack createItemStack(UUID player) {
        ItemStack stack = new ItemStack(this.item);
        this.tag.map(CompoundTag::m_6426_).ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        Collectible.addMarkerTo(player, stack);
        return stack;
    }

    public static void addMarkerTo(UUID player, ItemStack stack) {
        stack.m_41784_().m_128362_(KEY_ITEM_STACK_MARKER, player);
    }

    public Holder<Item> item() {
        return this.item;
    }

    public Optional<CompoundTag> tag() {
        return this.tag;
    }

    public boolean matches(ItemStack stack) {
        if (!stack.m_220165_(this.item) || !Collectible.isCollectible(stack)) {
            return false;
        }
        CompoundTag tag = Collectible.getTagWithoutMarker(stack);
        return tag.equals((Object)this.tag.orElseGet(CompoundTag::new));
    }

    private static CompoundTag getTagWithoutMarker(ItemStack stack) {
        CompoundTag tag = stack.m_41784_().m_6426_();
        tag.m_128473_(KEY_ITEM_STACK_MARKER);
        return tag;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Collectible) {
            Collectible collectible = (Collectible)obj;
            return this.item.equals(collectible.item) && Objects.equals(this.tag, collectible.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.item.hashCode() * 31 + Objects.hashCode(this.tag);
    }
}

