/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleLister;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CollectibleCommand {
    private static final SimpleCommandExceptionType GAVE_TO_NO_PLAYERS = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Did not find any players to give this collectible to"));
    private static final SimpleCommandExceptionType CLEARED_FROM_NO_PLAYERS = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Did not find any players to remove this collectible from"));
    private static final ResourceKey<Item> DISGUISE = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("ltminigames", "disguise"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"collectible").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(c -> CollectibleCommand.give((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"target"), ItemArgument.m_120963_((CommandContext)c, (String)"item"))))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(c -> CollectibleCommand.clear((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"target"), (Predicate<ItemStack>)ItemArgument.m_120963_((CommandContext)c, (String)"item"))))).executes(c -> CollectibleCommand.clear((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"target"), i -> true))))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CollectibleCommand.setLocked((CommandContext<CommandSourceStack>)context, true))))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> CollectibleCommand.setLocked((CommandContext<CommandSourceStack>)context, false))))).then(Commands.m_82127_((String)"countdisguises").executes(CollectibleCommand::countDisguises))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"find").executes(context -> CollectibleCommand.findCollectibles((CommandSourceStack)context.getSource(), stack -> true))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)buildContext)).executes(context -> CollectibleCommand.findCollectibles((CommandSourceStack)context.getSource(), (Predicate<ItemStack>)ItemArgument.m_120963_((CommandContext)context, (String)"item"))))));
    }

    private static int give(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, ItemInput item) throws CommandSyntaxException {
        ItemStack stack = item.m_120980_(1, true);
        Collectible collectible = new Collectible(stack);
        int result = 0;
        for (ServerPlayer player : players) {
            CollectibleStore collectibles = CollectibleStore.getNullable((Player)player);
            if (collectibles == null || !collectibles.give(collectible)) continue;
            ++result;
        }
        if (result == 0) {
            throw GAVE_TO_NO_PLAYERS.create();
        }
        int finalResult = result;
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"Gave %s to %s players", (Object[])new Object[]{stack.m_41611_(), finalResult}), false);
        return result;
    }

    private static int clear(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, Predicate<ItemStack> itemPredicate) throws CommandSyntaxException {
        Predicate<Collectible> predicate = collectible -> itemPredicate.test(collectible.createItemStack(Util.f_137441_));
        int count = 0;
        for (ServerPlayer player : players) {
            CollectibleStore collectibles = CollectibleStore.getNullable((Player)player);
            if (collectibles == null || !collectibles.clear(predicate)) continue;
            CollectibleCommand.clearCollectibleItems(player.m_150109_(), predicate);
            ++count;
        }
        if (count == 0) {
            throw CLEARED_FROM_NO_PLAYERS.create();
        }
        int finalCount = count;
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"Cleared collectibles from %s players", (Object[])new Object[]{finalCount}), false);
        return finalCount;
    }

    private static void clearCollectibleItems(Inventory inventory, Predicate<Collectible> predicate) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            Collectible collectible = Collectible.byItem(stack);
            if (collectible == null || !predicate.test(collectible)) continue;
            inventory.m_8016_(i);
        }
    }

    private static int countDisguises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CollectibleStore collectibles = CollectibleStore.getNullable((Player)player);
        if (collectibles == null) {
            return 0;
        }
        return collectibles.count(collectible -> {
            if (collectible.item().m_203565_(DISGUISE)) {
                return collectible.tag().isEmpty() || !collectible.tag().get().m_128471_("donation_goal");
            }
            return false;
        });
    }

    private static int setLocked(CommandContext<CommandSourceStack> context, boolean locked) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CollectibleStore store = CollectibleStore.getNullable((Player)player);
        if (store != null) {
            store.setLocked(locked);
        }
        return 1;
    }

    private static int findCollectibles(CommandSourceStack source, Predicate<ItemStack> item) {
        MinecraftServer server = source.m_81377_();
        GameProfileCache profileCache = server.m_129927_();
        ((CompletableFuture)CollectibleLister.listPlayersWithItem(server, item).thenApplyAsync(profileIds -> profileIds.stream().map(arg_0 -> ((GameProfileCache)profileCache).m_11002_(arg_0)).flatMap(Optional::stream).toList(), (Executor)Util.m_183991_())).thenAcceptAsync(profiles -> {
            if (profiles.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"Found no players"), false);
            } else {
                String names = profiles.stream().map(GameProfile::getName).collect(Collectors.joining(", "));
                source.m_288197_(() -> Component.m_237113_((String)("Found " + profiles.size() + " players: " + names)), false);
            }
        }, (Executor)server);
        return 1;
    }
}

