/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ltextras")
public class CollectibleItemBehavior {
    private static final int INVENTORY_CHECK_INTERVAL = 20;

    public static boolean onItemToss(Player player, ItemEntity item) {
        ItemStack stack = item.m_32055_();
        if (Collectible.isCollectible(stack)) {
            player.m_36356_(stack);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().m_32055_();
        Collectible collectible = Collectible.byItem(stack);
        if (collectible == null) {
            return;
        }
        Player player = event.getEntity();
        if (Collectible.isIllegalCollectible(stack, player)) {
            stack.m_41764_(0);
            event.getItem().m_146870_();
            event.setCanceled(true);
        } else {
            CollectibleStore store = CollectibleStore.getNullable(player);
            if (store != null) {
                store.give(collectible);
                Collectible.addMarkerTo(player.m_20148_(), stack);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        event.getDrops().removeIf(item -> Collectible.isCollectible(item.m_32055_()));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            Inventory inventory;
            int count;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_19797_ % 20 == 0 && (count = (inventory = serverPlayer.m_150109_()).m_36022_(stack -> Collectible.isIllegalCollectible(stack, (Player)serverPlayer), -1, (Container)serverPlayer.f_36095_.m_39730_())) > 0) {
                serverPlayer.f_36096_.m_38946_();
                serverPlayer.f_36095_.m_6199_((Container)inventory);
            }
        }
    }

    @SubscribeEvent
    public static void onDestroyItem(PlayerDestroyItemEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack item = event.getOriginal();
            if (Collectible.isCollectible(item)) {
                player2.m_36356_(item);
            }
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (Collectible.isCollectible(stack) && event.getResultStack().m_41619_()) {
            event.setResultStack(stack);
        }
    }

    public static InteractionResultHolder<ItemStack> wrapUse(ItemStack stack, Level level, Player player, InteractionHand hand) {
        if (Collectible.isCollectible(stack)) {
            int count = stack.m_41613_();
            InteractionResultHolder result = stack.m_41720_().m_7203_(level, player, hand);
            stack.m_41764_(count);
            return result;
        }
        return stack.m_41720_().m_7203_(level, player, hand);
    }

    public static InteractionResult wrapUseOn(ItemStack stack, UseOnContext context) {
        if (Collectible.isCollectible(stack)) {
            int count = stack.m_41613_();
            InteractionResult result = stack.m_41661_(context);
            stack.m_41764_(count);
            return result;
        }
        return stack.m_41661_(context);
    }
}

