/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleData;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.mixin.MinecraftServerAccessor;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CollectibleLister {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static CompletableFuture<List<UUID>> listPlayersWithItem(MinecraftServer server, Predicate<ItemStack> item) {
        return CollectibleLister.list(server).thenApplyAsync(entries -> {
            ArrayList<UUID> profileIds = new ArrayList<UUID>();
            for (Entry entry : entries) {
                for (Collectible collectible : entry.data().collectibles()) {
                    ItemStack stack = collectible.createItemStack(entry.profileId());
                    if (!item.test(stack)) continue;
                    profileIds.add(entry.profileId());
                }
            }
            return profileIds;
        }, (Executor)Util.m_183991_());
    }

    public static CompletableFuture<List<Entry>> list(MinecraftServer server) {
        ObjectOpenHashSet seenProfileIds = new ObjectOpenHashSet();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            CollectibleStore store = CollectibleStore.getNullable((Player)player);
            if (store == null) continue;
            entries.add(new Entry(player.m_20148_(), store.asData()));
            seenProfileIds.add(player.m_20148_());
        }
        PlayerDataStorage playerDataStorage = ((MinecraftServerAccessor)server).getPlayerDataStorage();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> ((PlayerDataStorage)playerDataStorage).m_78432_(), Util.m_183992_()).thenCompose(arg_0 -> CollectibleLister.lambda$list$2((Set)seenProfileIds, playerDataStorage, arg_0))).thenApply(loadedEntries -> {
            for (Entry entry : loadedEntries) {
                if (entry == null) continue;
                entries.add(entry);
            }
            return entries;
        });
    }

    @Nullable
    private static Entry loadPlayerData(String player, PlayerDataStorage playerDataStorage, UUID profileId) {
        CompoundTag tag;
        try {
            Path path = playerDataStorage.getPlayerDataFolder().toPath().resolve(player + ".dat");
            tag = NbtIo.m_128937_((File)path.toFile());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load player data for {}", (Object)profileId, (Object)e);
            return null;
        }
        CompoundTag forgeCaps = tag.m_128469_("ForgeCaps");
        Tag collectiblesTag = forgeCaps.m_128423_(CollectibleStore.ID.toString());
        if (collectiblesTag == null) {
            return null;
        }
        return CollectibleData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)collectiblesTag).resultOrPartial(Util.m_137489_((String)("Failed to parse player data for " + profileId), arg_0 -> ((Logger)LOGGER).warn(arg_0))).map(data -> new Entry(profileId, (CollectibleData)data)).orElse(null);
    }

    private static /* synthetic */ CompletionStage lambda$list$2(Set seenProfileIds, PlayerDataStorage playerDataStorage, String[] seenPlayers) {
        ArrayList<CompletableFuture<Entry>> futures = new ArrayList<CompletableFuture<Entry>>();
        for (String player : seenPlayers) {
            try {
                UUID profileId = UUID.fromString(player);
                if (seenProfileIds.contains(profileId)) continue;
                futures.add(CompletableFuture.supplyAsync(() -> CollectibleLister.loadPlayerData(player, playerDataStorage, profileId), Util.m_183992_()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Util.m_137567_(futures);
    }

    public record Entry(UUID profileId, CollectibleData data) {
    }
}

