/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleData;
import com.lovetropics.extras.network.CollectiblesListPacket;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="ltextras")
public class CollectibleStore
implements ICapabilitySerializable<Tag> {
    public static final ResourceLocation ID = new ResourceLocation("ltextras", "collectibles");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LazyOptional<CollectibleStore> instance = LazyOptional.of(() -> this);
    private final ServerPlayer player;
    private final List<Collectible> collectibles = new ArrayList<Collectible>();
    private boolean hasUnseen;
    private boolean locked;

    private CollectibleStore(ServerPlayer player) {
        this.player = player;
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            event.addCapability(ID, (ICapabilityProvider)new CollectibleStore(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CollectibleStore collectibles = CollectibleStore.getNullable(event.getEntity());
        if (collectibles != null) {
            collectibles.sendToClient(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.reviveCaps();
        try {
            CollectibleStore oldCollectibles = CollectibleStore.getNullable(oldPlayer);
            CollectibleStore newCollectibles = CollectibleStore.getNullable(event.getEntity());
            if (oldCollectibles != null && newCollectibles != null) {
                newCollectibles.collectibles.addAll(oldCollectibles.collectibles);
                newCollectibles.sendToClient(true);
            }
        }
        finally {
            oldPlayer.invalidateCaps();
        }
    }

    @Nullable
    public static CollectibleStore getNullable(Player player) {
        return (CollectibleStore)player.getCapability(LTExtras.COLLECTIBLE_STORE).orElse(null);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return LTExtras.COLLECTIBLE_STORE.orEmpty(cap, this.instance);
    }

    public Tag serializeNBT() {
        return (Tag)Util.m_260975_((DataResult)CollectibleData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.asData()), IllegalStateException::new);
    }

    public CollectibleData asData() {
        return new CollectibleData(this.collectibles, this.hasUnseen);
    }

    public void deserializeNBT(Tag nbt) {
        CollectibleData.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(Util.m_137489_((String)"Collectibles: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(data -> {
            this.collectibles.clear();
            this.collectibles.addAll(data.collectibles());
            this.hasUnseen = data.hasUnseen();
        });
    }

    public boolean give(Collectible collectible) {
        if (!this.collectibles.contains(collectible)) {
            this.collectibles.add(collectible);
            this.hasUnseen = true;
            this.sendToClient(false);
            return true;
        }
        return false;
    }

    public boolean clear(Predicate<Collectible> predicate) {
        if (this.collectibles.removeIf(predicate)) {
            this.sendToClient(false);
            return true;
        }
        return false;
    }

    public boolean contains(Collectible collectible) {
        return this.collectibles.contains(collectible);
    }

    public int count(Predicate<Collectible> predicate) {
        int count = 0;
        for (Collectible collectible : this.collectibles) {
            if (!predicate.test(collectible)) continue;
            ++count;
        }
        return count;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void markSeen() {
        this.hasUnseen = false;
    }

    private void sendToClient(boolean silent) {
        LTExtrasNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> this.player), (Object)new CollectiblesListPacket(this.collectibles, silent, this.hasUnseen));
    }
}

