/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraftforge.registries.ForgeRegistries;

public class GenerateCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType FAILED_TO_WRITE = new DynamicCommandExceptionType(o -> Component.m_237113_((String)("Failed to write to file: " + o)));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"generate").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"tag").then(Commands.m_82127_((String)"item").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes(GenerateCommand::generateItemTag))))));
    }

    private static int generateItemTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Pattern pattern = Pattern.compile(StringArgumentType.getString(ctx, (String)"pattern"));
        TagBuilder tagBuilder = TagBuilder.m_215899_();
        for (Map.Entry e : ForgeRegistries.ITEMS.getEntries()) {
            ResourceLocation id = ((ResourceKey)e.getKey()).m_135782_();
            if (!pattern.matcher(id.toString()).matches()) continue;
            tagBuilder.m_215900_(id);
        }
        JsonElement json = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(tagBuilder.m_215904_(), false)).getOrThrow(false, System.err::println);
        Path output = Paths.get("export", "generated", "tags", "item", StringArgumentType.getString(ctx, (String)"name") + ".json");
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, Collections.singleton(GSON.toJson(json)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw FAILED_TO_WRITE.create((Object)e1);
        }
        return 1;
    }
}

