/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.lovetropics.extras.data.poi.MapPoiManager;
import com.lovetropics.extras.data.poi.Poi;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class PoiCommand {
    private static final String COMMAND_BASE = "poi";
    private static final SimpleCommandExceptionType GENERAL_ERROR = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"General error"));
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"POI not found"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"description", (ArgumentType)ComponentArgument.m_87114_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"icon", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(PoiCommand::addWithDefaults)).then(Commands.m_82129_((String)"blockpos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(PoiCommand::add))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestDisabledPois((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::enable))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestEnabledPois((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::disable))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestName((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::get))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"edit").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestName((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"description", (ArgumentType)ComponentArgument.m_87114_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestDescription((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"icon", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82957_(PoiCommand.suggestIcon((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"blockpos", (ArgumentType)BlockPosArgument.m_118239_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestGlobalPos((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestEnabled((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::edit))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"list").executes(PoiCommand::list)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_BASE).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(PoiCommand.suggestName((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::delete))));
    }

    private static int delete(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        MapPoiManager manager = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_());
        Poi poi = manager.getPoi(StringArgumentType.getString(ctx, (String)"name"));
        if (poi == null) {
            throw NOT_FOUND.create();
        }
        manager.remove(poi.name());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Deleted POI " + poi.name())), false);
        return 1;
    }

    private static int get(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(StringArgumentType.getString(ctx, (String)"name"));
        if (poi == null) {
            throw NOT_FOUND.create();
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)poi.toString()), false);
        return 1;
    }

    private static int list(CommandContext<CommandSourceStack> ctx) {
        MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getAllPois().forEach(poi -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)poi.toString()), false));
        return 1;
    }

    private static int add(CommandContext<CommandSourceStack> ctx) {
        Poi newPoi = PoiCommand.createPoiFromCtx(ctx);
        MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).add(newPoi);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added new POI " + newPoi.name())), false);
        return 1;
    }

    private static int addWithDefaults(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Component description = ComponentArgument.m_87117_(ctx, (String)"description");
        ResourceLocation icon = ResourceLocationArgument.m_107011_(ctx, (String)"icon");
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_(), (BlockPos)((CommandSourceStack)ctx.getSource()).m_230896_().m_20097_().m_7494_());
        boolean enabled = false;
        List<UUID> faces = List.of();
        Poi newPoi = new Poi(name, description, icon, globalPos, false, faces);
        MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).add(newPoi);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added new disabled POI " + newPoi.name() + " at your current position")), false);
        return 1;
    }

    private static int enable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (!MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).enable(name)) {
            throw GENERAL_ERROR.create();
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Enabled POI \"" + name + "\"")), false);
        return 1;
    }

    private static int disable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (!MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).disable(name)) {
            throw GENERAL_ERROR.create();
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Disabled POI \"" + name + "\"")), false);
        return 1;
    }

    private static int edit(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(StringArgumentType.getString(ctx, (String)"name"));
        if (poi == null) {
            throw NOT_FOUND.create();
        }
        Poi updatedPoi = PoiCommand.createPoiFromCtx(ctx);
        MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).add(updatedPoi);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Updated POI \"" + poi.name() + "\"")), false);
        return 1;
    }

    private static Stream<String> suggestEnabledPois(CommandContext<CommandSourceStack> ctx) {
        return MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getEnabledPois().stream().map(Poi::name);
    }

    private static Stream<String> suggestDisabledPois(CommandContext<CommandSourceStack> ctx) {
        return MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getDisabledPois().stream().map(Poi::name);
    }

    private static Stream<String> suggestName(CommandContext<CommandSourceStack> ctx) {
        return MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getAllPois().stream().map(Poi::name);
    }

    private static Stream<String> suggestDescription(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(name);
        if (poi != null) {
            return Stream.of("\"" + poi.description() + "\"");
        }
        return Stream.empty();
    }

    private static Stream<String> suggestEnabled(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(name);
        if (poi != null) {
            return Stream.of(String.valueOf(poi.enabled()));
        }
        return Stream.empty();
    }

    private static Poi createPoiFromCtx(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Component description = ComponentArgument.m_87117_(ctx, (String)"description");
        ResourceLocation icon = ResourceLocationArgument.m_107011_(ctx, (String)"icon");
        WorldCoordinates worldCoordinates = (WorldCoordinates)ctx.getArgument("blockpos", WorldCoordinates.class);
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)((CommandSourceStack)ctx.getSource()).m_81372_().m_46472_(), (BlockPos)worldCoordinates.m_119568_((CommandSourceStack)ctx.getSource()));
        boolean enabled = BoolArgumentType.getBool(ctx, (String)"enabled");
        List<UUID> faces = List.of();
        return new Poi(name, description, icon, globalPos, enabled, faces);
    }

    private static Stream<String> suggestGlobalPos(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(name);
        if (poi != null) {
            return Stream.of(poi.globalPos().m_122646_().toString());
        }
        return Stream.empty();
    }

    private static Stream<ResourceLocation> suggestIcon(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Poi poi = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(name);
        if (poi != null) {
            return Stream.of(poi.resourceLocation());
        }
        return Stream.empty();
    }
}

