/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.lovetropics.extras.data.poi.MapPoiManager;
import com.lovetropics.extras.data.poi.Poi;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class WarpCommand {
    private static final String ARGUMENT_TARGET = "target";
    private static final SimpleCommandExceptionType GENERAL_ERROR = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.warp.general_error"));
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.warp.not_found"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"warp").then(Commands.m_82129_((String)ARGUMENT_TARGET, (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            MapPoiManager poiManager = MapPoiManager.get(((CommandSourceStack)context.getSource()).m_81377_());
            return SharedSuggestionProvider.m_82981_(poiManager.getEnabledPois().stream().map(Poi::name), (SuggestionsBuilder)builder);
        }).executes(WarpCommand::warp)));
    }

    private static int warp(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = (String)ctx.getArgument(ARGUMENT_TARGET, String.class);
        Poi target = MapPoiManager.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPoi(targetName);
        if (target == null) {
            throw NOT_FOUND.create();
        }
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        BlockPos blockPos = target.globalPos().m_122646_();
        ServerLevel level = player.m_20194_().m_129880_(target.globalPos().m_122640_());
        if (!target.enabled() && !player.m_20310_(2)) {
            throw GENERAL_ERROR.create();
        }
        player.m_8999_(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.warp.success", (Object[])new Object[]{target.description()}), false);
        return 1;
    }

    public static void addTranslations(RegistrateLangProvider provider) {
        provider.add("commands.warp.general_error", "Couldn't go there");
        provider.add("commands.warp.success", "Warped to %s");
        provider.add("commands.warp.not_found", "Destination not found");
    }
}

